/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping;

import org.compass.core.converter.ConversionException;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourcePropertyMapping;

public final class ResourcePropertyLookup {
    private AliasMapping aliasMapping;
    private ResourcePropertyMapping resourcePropertyMapping;
    private ResourcePropertyMapping[] resourcePropertyMappings;
    private String lookupName;
    private String path;
    private String dotPathAlias;
    private boolean convertOnlyWithDotPath = true;
    private CompassMapping compassMapping;

    public ResourcePropertyLookup(CompassMapping compassMapping, String name) {
        this.compassMapping = compassMapping;
        this.lookupName = name;
        if (name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
            this.path = name.substring(1, name.length() - 1);
        } else {
            int dotIndex = name.indexOf(46);
            if (dotIndex != -1) {
                this.dotPathAlias = name.substring(0, dotIndex);
                this.aliasMapping = compassMapping.getAliasMapping(this.dotPathAlias);
            }
            this.resourcePropertyMapping = compassMapping.getResourcePropertyMappingByPath(name);
            this.path = this.resourcePropertyMapping == null ? name : this.resourcePropertyMapping.getPath().getPath();
            this.resourcePropertyMappings = compassMapping.getResourcePropertyMappingsByPath(this.path);
            if (this.resourcePropertyMappings != null && this.resourcePropertyMapping == null) {
                this.resourcePropertyMapping = this.resourcePropertyMappings[0];
            }
        }
    }

    public void setConvertOnlyWithDotPath(boolean convertOnlyWithDotPath) {
        this.convertOnlyWithDotPath = convertOnlyWithDotPath;
    }

    public String getAnalyzer() {
        if (this.resourcePropertyMapping != null && this.resourcePropertyMapping.getAnalyzer() != null) {
            return this.resourcePropertyMapping.getAnalyzer();
        }
        return null;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public String getDotPathAlias() {
        return this.dotPathAlias;
    }

    public AliasMapping getAliasMapping() {
        return this.aliasMapping;
    }

    public String getPath() {
        return this.path;
    }

    public ResourcePropertyMapping getResourcePropertyMapping() {
        return this.resourcePropertyMapping;
    }

    public ResourcePropertyMapping[] getResourcePropertyMappings() {
        if (this.resourcePropertyMappings == null && this.resourcePropertyMapping != null) {
            this.resourcePropertyMappings = new ResourcePropertyMapping[]{this.resourcePropertyMapping};
        }
        return this.resourcePropertyMappings;
    }

    public boolean hasSpecificConverter() {
        if (this.dotPathAlias == null && this.convertOnlyWithDotPath) {
            return false;
        }
        return this.resourcePropertyMapping != null && this.resourcePropertyMapping.getConverter() != null;
    }

    public String getValue(Object value) {
        if (value instanceof String) {
            return this.normalizeString((String)value);
        }
        ResourcePropertyConverter converter = null;
        if (this.hasSpecificConverter()) {
            converter = this.resourcePropertyMapping.getResourcePropertyConverter();
        }
        if (converter == null) {
            converter = (ResourcePropertyConverter)this.compassMapping.getConverterLookup().lookupConverter(value.getClass());
        }
        return converter.toString(value, this.resourcePropertyMapping);
    }

    public Object fromString(String value) {
        ResourcePropertyConverter converter = this.hasSpecificConverter() ? this.resourcePropertyMapping.getResourcePropertyConverter() : (ResourcePropertyConverter)this.compassMapping.getConverterLookup().lookupConverter(value.getClass());
        return converter.fromString(value, this.resourcePropertyMapping);
    }

    public String attemptNormalizeString(String value) {
        try {
            return this.normalizeString(value);
        }
        catch (ConversionException e) {
            return value;
        }
    }

    public String normalizeString(String value) throws ConversionException {
        if (!this.hasSpecificConverter()) {
            return value;
        }
        ResourcePropertyConverter converter = this.resourcePropertyMapping.getResourcePropertyConverter();
        if (converter == null) {
            return value;
        }
        if (!converter.canNormalize()) {
            return value;
        }
        return converter.toString(converter.fromString(value, this.resourcePropertyMapping), this.resourcePropertyMapping);
    }
}

