/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json.builder;

import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourceMappingProvider;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.json.Naming;
import org.compass.core.mapping.json.RootJsonObjectMapping;
import org.compass.core.mapping.json.builder.JsonAllMappingBuilder;
import org.compass.core.mapping.json.builder.JsonAnalyzerMappingBuilder;
import org.compass.core.mapping.json.builder.JsonArrayMappingBuilder;
import org.compass.core.mapping.json.builder.JsonBoostMappingBuilder;
import org.compass.core.mapping.json.builder.JsonContentMappingBuilder;
import org.compass.core.mapping.json.builder.JsonIdMappingBuilder;
import org.compass.core.mapping.json.builder.JsonObjectMappingBuilder;
import org.compass.core.mapping.json.builder.JsonPropertyMappingBuilder;

public class JsonMappingBuilder
implements ResourceMappingProvider {
    private final RootJsonObjectMapping mapping = new RootJsonObjectMapping();

    public JsonMappingBuilder(String alias) {
        this.mapping.setRoot(true);
        this.mapping.setAlias(alias);
    }

    public ResourceMapping getMapping() {
        return this.mapping;
    }

    public JsonMappingBuilder subIndex(String subIndex) {
        this.mapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        return this;
    }

    public JsonMappingBuilder subIndex(SubIndexHash subIndexHash) {
        this.mapping.setSubIndexHash(subIndexHash);
        return this;
    }

    public JsonMappingBuilder extendsAliases(String ... extendedAliases) {
        this.mapping.setExtendedAliases(extendedAliases);
        return this;
    }

    public JsonMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }

    public JsonMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public JsonMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public JsonMappingBuilder dynamic(boolean dynamic) {
        this.mapping.setDynamic(dynamic);
        return this;
    }

    public JsonMappingBuilder dynamicNaming(Naming dynamicNaming) {
        this.mapping.setDynamicNaming(dynamicNaming);
        return this;
    }

    public JsonMappingBuilder all(JsonAllMappingBuilder allMappingBuilder) {
        this.mapping.setAllMapping(allMappingBuilder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonIdMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonPropertyMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonAnalyzerMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonBoostMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonContentMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonObjectMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public JsonMappingBuilder add(JsonArrayMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }
}

