/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.osem.builder;

import org.compass.core.Property;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;

public class SearchableMetaDataMappingBuilder {
    final ClassPropertyMetaDataMapping mapping = new ClassPropertyMetaDataMapping();

    public SearchableMetaDataMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
    }

    public SearchableMetaDataMappingBuilder store(Property.Store store) {
        this.mapping.setStore(store);
        return this;
    }

    public SearchableMetaDataMappingBuilder index(Property.Index index) {
        this.mapping.setIndex(index);
        return this;
    }

    public SearchableMetaDataMappingBuilder termVector(Property.TermVector termVector) {
        this.mapping.setTermVector(termVector);
        return this;
    }

    public SearchableMetaDataMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public SearchableMetaDataMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public SearchableMetaDataMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public SearchableMetaDataMappingBuilder format(String format) {
        this.mapping.setConverter(new FormatDelegateConverter(format));
        return this;
    }

    public SearchableMetaDataMappingBuilder converter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public SearchableMetaDataMappingBuilder converter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public SearchableMetaDataMappingBuilder converter(ResourcePropertyConverter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public SearchableMetaDataMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public SearchableMetaDataMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public SearchableMetaDataMappingBuilder nullValue(String nullValue) {
        this.mapping.setNullValue(nullValue);
        return this;
    }

    public SearchableMetaDataMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

