/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.rsem.builder;

import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.rsem.RawResourcePropertyIdMapping;

public class ResourceIdMappingBuilder {
    final RawResourcePropertyIdMapping mapping = new RawResourcePropertyIdMapping();

    public ResourceIdMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setPath(new StaticPropertyPath(name));
        this.mapping.setOmitNorms(true);
        this.mapping.setOmitTf(true);
    }

    public ResourceIdMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public ResourceIdMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public ResourceIdMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public ResourceIdMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public ResourceIdMappingBuilder format(String format) {
        this.mapping.setConverter(new FormatDelegateConverter(format));
        return this;
    }

    public ResourceIdMappingBuilder converter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public ResourceIdMappingBuilder converter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public ResourceIdMappingBuilder converter(ResourcePropertyConverter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public ResourceIdMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public ResourceIdMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

