/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.rsem.builder;

import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourceMappingProvider;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.rsem.builder.ResourceAllMappingBuilder;
import org.compass.core.mapping.rsem.builder.ResourceAnalyzerMappingBuilder;
import org.compass.core.mapping.rsem.builder.ResourceBoostMappingBuilder;
import org.compass.core.mapping.rsem.builder.ResourceIdMappingBuilder;
import org.compass.core.mapping.rsem.builder.ResourcePropertyMappingBuilder;

public class ResourceMappingBuilder
implements ResourceMappingProvider {
    private final RawResourceMapping mapping = new RawResourceMapping();

    public ResourceMappingBuilder(String alias) {
        this.mapping.setAlias(alias);
        this.mapping.setRoot(true);
    }

    public ResourceMapping getMapping() {
        return this.mapping;
    }

    public ResourceMappingBuilder subIndex(String subIndex) {
        this.mapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
        return this;
    }

    public ResourceMappingBuilder subIndex(SubIndexHash subIndexHash) {
        this.mapping.setSubIndexHash(subIndexHash);
        return this;
    }

    public ResourceMappingBuilder extendsAliases(String ... extendedAliases) {
        this.mapping.setExtendedAliases(extendedAliases);
        return this;
    }

    public ResourceMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }

    public ResourceMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public ResourceMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public ResourceMappingBuilder all(ResourceAllMappingBuilder allMappingBuilder) {
        this.mapping.setAllMapping(allMappingBuilder.mapping);
        return this;
    }

    public ResourceMappingBuilder add(ResourceIdMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public ResourceMappingBuilder add(ResourcePropertyMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public ResourceMappingBuilder add(ResourceAnalyzerMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }

    public ResourceMappingBuilder add(ResourceBoostMappingBuilder builder) {
        this.mapping.addMapping(builder.mapping);
        return this;
    }
}

