/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.xsem.builder;

import org.compass.core.Property;
import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.xsem.XmlPropertyMapping;

public class XmlPropertyMappingBuilder {
    final XmlPropertyMapping mapping = new XmlPropertyMapping();

    public XmlPropertyMappingBuilder(String xpath) {
        this.mapping.setXPath(xpath);
    }

    public XmlPropertyMappingBuilder indexName(String indexName) {
        this.mapping.setName(indexName);
        this.mapping.setPath(new StaticPropertyPath(indexName));
        return this;
    }

    public XmlPropertyMappingBuilder store(Property.Store store) {
        this.mapping.setStore(store);
        return this;
    }

    public XmlPropertyMappingBuilder index(Property.Index index) {
        this.mapping.setIndex(index);
        return this;
    }

    public XmlPropertyMappingBuilder termVector(Property.TermVector termVector) {
        this.mapping.setTermVector(termVector);
        return this;
    }

    public XmlPropertyMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public XmlPropertyMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public XmlPropertyMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public XmlPropertyMappingBuilder format(String format) {
        this.mapping.setValueConverter(new FormatDelegateConverter(format));
        this.mapping.setFormat(format);
        return this;
    }

    public XmlPropertyMappingBuilder mappingConverter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public XmlPropertyMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public XmlPropertyMappingBuilder valueConverter(String converterName) {
        this.mapping.setValueConverterName(converterName);
        return this;
    }

    public XmlPropertyMappingBuilder valueConverter(Converter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public XmlPropertyMappingBuilder valueConverter(ResourcePropertyConverter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public XmlPropertyMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public XmlPropertyMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public XmlPropertyMappingBuilder nullValue(String nullValue) {
        this.mapping.setNullValue(nullValue);
        return this;
    }

    public XmlPropertyMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

