/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import java.util.ArrayList;
import java.util.List;
import org.compass.core.util.StringUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DomUtils {
    public static String getElementAttribute(Element ele, String attributeName) {
        return DomUtils.getElementAttribute(ele, attributeName, null);
    }

    public static String getElementAttribute(Element ele, String attributeName, String defaultValue) {
        String value = ele.getAttribute(attributeName);
        if (value == null || !StringUtils.hasText(value)) {
            return defaultValue;
        }
        return value;
    }

    public static boolean getElementAttributeAsBoolean(Element ele, String attributeName, boolean defaultValue) {
        String sValue = DomUtils.getElementAttribute(ele, attributeName);
        if (sValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(sValue);
    }

    public static List getChildElementsByTagName(Element ele, String childEleName) {
        return DomUtils.getChildElementsByTagName(ele, childEleName, false);
    }

    public static List getChildElementsByTagName(Element ele, String childEleName, boolean localName) {
        NodeList nl = ele.getChildNodes();
        ArrayList<Node> childEles = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            Node node = nl.item(i);
            String string = name = localName ? node.getLocalName() : node.getNodeName();
            if (!(node instanceof Element) || !childEleName.equals(name)) continue;
            childEles.add(node);
        }
        return childEles;
    }

    public static String getTrimmedTextValue(Element valueEle) {
        return DomUtils.getTextValue(valueEle).trim();
    }

    public static String getTextValue(Element valueEle) {
        StringBuffer value = new StringBuffer();
        NodeList nl = valueEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value.append(item.getNodeValue());
        }
        return value.toString();
    }
}

