/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.compass.core.util.Assert;
import org.compass.core.util.ClassUtils;
import org.compass.gps.CompassGpsException;
import org.compass.gps.PassiveMirrorGpsDevice;
import org.compass.gps.device.hibernate.DefaultHibernateQueryProvider;
import org.compass.gps.device.hibernate.HibernateEntityIndexInfo;
import org.compass.gps.device.hibernate.HibernateGpsDeviceException;
import org.compass.gps.device.hibernate.HibernateQueryProvider;
import org.compass.gps.device.hibernate.NativeHibernateExtractor;
import org.compass.gps.device.hibernate.entities.DefaultHibernateEntitiesLocator;
import org.compass.gps.device.hibernate.entities.EntityInformation;
import org.compass.gps.device.hibernate.entities.HibernateEntitiesLocator;
import org.compass.gps.device.hibernate.indexer.HibernateIndexEntitiesIndexer;
import org.compass.gps.device.hibernate.indexer.ScrollableHibernateIndexEntitiesIndexer;
import org.compass.gps.device.hibernate.lifecycle.DefaultHibernateEntityLifecycleInjector;
import org.compass.gps.device.hibernate.lifecycle.HibernateEntityLifecycleInjector;
import org.compass.gps.device.hibernate.lifecycle.HibernateMirrorFilter;
import org.compass.gps.device.support.parallel.AbstractParallelGpsDevice;
import org.compass.gps.device.support.parallel.IndexEntitiesIndexer;
import org.compass.gps.device.support.parallel.IndexEntity;
import org.hibernate.SessionFactory;

public class HibernateGpsDevice
extends AbstractParallelGpsDevice
implements PassiveMirrorGpsDevice {
    private SessionFactory sessionFactory;
    private boolean mirrorDataChanges = true;
    private int fetchCount = 200;
    private HibernateEntitiesLocator entitiesLocator;
    private HibernateEntityLifecycleInjector lifecycleInjector;
    private boolean ignoreMirrorExceptions;
    private HibernateMirrorFilter mirrorFilter;
    private NativeHibernateExtractor nativeExtractor;
    private HibernateIndexEntitiesIndexer entitiesIndexer;
    private Map<Class, HibernateQueryProvider> queryProviderByClass = new HashMap<Class, HibernateQueryProvider>();
    private Map<String, HibernateQueryProvider> queryProviderByName = new HashMap<String, HibernateQueryProvider>();
    private SessionFactory nativeSessionFactory;

    public HibernateGpsDevice() {
    }

    public HibernateGpsDevice(String name, SessionFactory sessionFactory) {
        this.setName(name);
        this.setSessionFactory(sessionFactory);
    }

    protected void doStart() throws CompassGpsException {
        Assert.notNull(this.sessionFactory, this.buildMessage("Must set Hibernate SessionFactory"));
        this.nativeSessionFactory = this.sessionFactory;
        if (this.nativeExtractor != null) {
            this.nativeSessionFactory = this.nativeExtractor.extractNative(this.sessionFactory);
            if (this.nativeSessionFactory == null) {
                throw new HibernateGpsDeviceException(this.buildMessage("Native SessionFactory extractor returned null"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using native SessionFactory [" + this.nativeSessionFactory.getClass().getName() + "] extracted by [" + this.nativeExtractor.getClass().getName() + "]"));
            }
        }
        if (this.entitiesLocator == null) {
            this.entitiesLocator = new DefaultHibernateEntitiesLocator();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.buildMessage("Using index entityLocator [" + this.entitiesLocator.getClass().getName() + "]"));
        }
        if (this.mirrorDataChanges) {
            if (this.lifecycleInjector == null) {
                try {
                    ClassUtils.forName("org.hibernate.event.PostCollectionRecreateEventListener", this.compassGps.getMirrorCompass().getSettings().getClassLoader());
                    this.lifecycleInjector = (HibernateEntityLifecycleInjector)ClassUtils.forName("org.compass.gps.device.hibernate.lifecycle.DefaultHibernateEntityCollectionLifecycleInjector", this.compassGps.getMirrorCompass().getSettings().getClassLoader()).newInstance();
                }
                catch (Exception e) {
                    this.lifecycleInjector = new DefaultHibernateEntityLifecycleInjector();
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)this.buildMessage("Using lifecycleInjector [" + this.lifecycleInjector.getClass().getName() + "]"));
            }
            this.lifecycleInjector.injectLifecycle(this.nativeSessionFactory, this);
        }
        if (this.entitiesIndexer == null) {
            this.entitiesIndexer = new ScrollableHibernateIndexEntitiesIndexer();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)this.buildMessage("Using entities indexer [" + this.entitiesIndexer.getClass().getName() + "]"));
        }
        this.entitiesIndexer.setHibernateGpsDevice(this);
    }

    protected void doStop() throws CompassGpsException {
        if (this.mirrorDataChanges) {
            this.lifecycleInjector.removeLifecycle(this.nativeSessionFactory, this);
        }
    }

    protected IndexEntity[] doGetIndexEntities() throws CompassGpsException {
        IndexEntity[] entitiesInformation;
        for (IndexEntity entityInformation : entitiesInformation = this.entitiesLocator.locate(this.nativeSessionFactory, this)) {
            if (this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()) != null) {
                ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByClass.get(((EntityInformation)entityInformation).getEntityClass()));
            }
            if (this.queryProviderByName.get(((EntityInformation)entityInformation).getName()) == null) continue;
            ((EntityInformation)entityInformation).setQueryProvider(this.queryProviderByName.get(((EntityInformation)entityInformation).getName()));
        }
        return entitiesInformation;
    }

    protected IndexEntitiesIndexer doGetIndexEntitiesIndexer() {
        return this.entitiesIndexer;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setFetchCount(int fetchCount) {
        this.fetchCount = fetchCount;
    }

    public int getFetchCount() {
        return this.fetchCount;
    }

    public boolean isMirrorDataChanges() {
        return this.mirrorDataChanges;
    }

    public boolean isIgnoreMirrorExceptions() {
        return this.ignoreMirrorExceptions;
    }

    public void setIgnoreMirrorExceptions(boolean ignoreMirrorExceptions) {
        this.ignoreMirrorExceptions = ignoreMirrorExceptions;
    }

    public void setMirrorDataChanges(boolean mirrorDataChanges) {
        this.mirrorDataChanges = mirrorDataChanges;
    }

    public void setEntitiesLocator(HibernateEntitiesLocator entitiesLocator) {
        this.entitiesLocator = entitiesLocator;
    }

    public HibernateMirrorFilter getMirrorFilter() {
        return this.mirrorFilter;
    }

    public void setMirrorFilter(HibernateMirrorFilter mirrorFilter) {
        this.mirrorFilter = mirrorFilter;
    }

    public void setNativeExtractor(NativeHibernateExtractor nativeExtractor) {
        this.nativeExtractor = nativeExtractor;
    }

    public void setEntitiesIndexer(HibernateIndexEntitiesIndexer entitiesIndexer) {
        this.entitiesIndexer = entitiesIndexer;
    }

    public void setLifecycleInjector(HibernateEntityLifecycleInjector lifecycleInjector) {
        this.lifecycleInjector = lifecycleInjector;
    }

    public void setIndexSelectQuery(Class entityClass, String selectQuery) {
        this.setIndexQueryProvider(entityClass, (HibernateQueryProvider)new DefaultHibernateQueryProvider(selectQuery));
    }

    public void setIndexSelectQuery(String entityName, String selectQuery) {
        this.setIndexQueryProvider(entityName, (HibernateQueryProvider)new DefaultHibernateQueryProvider(selectQuery));
    }

    public void setIndexQueryProvider(Class entityClass, HibernateQueryProvider queryProvider) {
        this.queryProviderByClass.put(entityClass, queryProvider);
    }

    public void setIndexQueryProvider(String entityName, HibernateQueryProvider queryProvider) {
        this.queryProviderByName.put(entityName, queryProvider);
    }

    public void setindexEntityInfo(HibernateEntityIndexInfo indexInfo) {
        if (indexInfo.getEntityName() == null) {
            throw new IllegalArgumentException("entityName must be provided");
        }
        this.setIndexQueryProvider(indexInfo.getEntityName(), indexInfo.getQueryProvider());
    }

    public void setindexEntityInfos(HibernateEntityIndexInfo[] indexInfos) {
        for (HibernateEntityIndexInfo indexInfo : indexInfos) {
            if (indexInfo.getEntityName() == null) {
                throw new IllegalArgumentException("entityName must be provided");
            }
            this.setIndexQueryProvider(indexInfo.getEntityName(), indexInfo.getQueryProvider());
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

