/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.service;

import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import org.compass.core.Compass;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.mapping.Cascade;
import org.compass.core.spi.InternalCompassSession;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.SpaceDataEventListener;
import org.springframework.transaction.TransactionStatus;

public class CompassIndexEventListener
implements SpaceDataEventListener {
    private CompassTemplate compassTemplate;

    public CompassIndexEventListener(Compass compass) {
        this.compassTemplate = new CompassTemplate(compass);
    }

    public void onEvent(final Object event, GigaSpace gigaSpace, TransactionStatus transactionStatus, Object source) {
        if (event instanceof Object[]) {
            final Object[] events = (Object[])event;
            final BatchRemoteEvent batchRemoteEvent = (BatchRemoteEvent)source;
            this.compassTemplate.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    for (int i = 0; i < events.length; ++i) {
                        CompassIndexEventListener.this.performOperation(session, events[i], (EntryArrivedRemoteEvent)batchRemoteEvent.getEvents()[i]);
                    }
                }
            });
        } else {
            final EntryArrivedRemoteEvent remoteEvent = (EntryArrivedRemoteEvent)source;
            this.compassTemplate.execute(new CompassCallbackWithoutResult(){

                protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                    CompassIndexEventListener.this.performOperation(session, event, remoteEvent);
                }
            });
        }
    }

    private void performOperation(CompassSession session, Object event, EntryArrivedRemoteEvent remoteEvent) {
        if (remoteEvent.getNotifyActionType() == NotifyActionType.NOTIFY_LEASE_EXPIRATION || remoteEvent.getNotifyActionType() == NotifyActionType.NOTIFY_TAKE) {
            if (((InternalCompassSession)session).getMapping().hasMappingForClass(event.getClass(), Cascade.DELETE)) {
                session.delete(event);
            }
        } else if ((remoteEvent.getNotifyActionType() == NotifyActionType.NOTIFY_UPDATE || remoteEvent.getNotifyActionType() == NotifyActionType.NOTIFY_WRITE) && ((InternalCompassSession)session).getMapping().hasMappingForClass(event.getClass(), Cascade.SAVE)) {
            session.save(event);
        }
    }
}

