/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.IOException;
import net.jini.core.entry.Entry;
import org.apache.lucene.store.IndexInput;
import org.compass.needle.gigaspaces.store.FileBucketEntry;
import org.compass.needle.gigaspaces.store.FileEntry;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectory;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;

class GigaSpaceIndexInput
extends IndexInput {
    private GigaSpaceDirectory dir;
    private FileEntry fileEntry;
    private long position;
    private FileBucketEntry bucketEntry;
    private int currentBucketPosition;

    public GigaSpaceIndexInput(GigaSpaceDirectory dir, FileEntry fileEntry) {
        this.dir = dir;
        this.fileEntry = fileEntry;
        this.bucketEntry = new FileBucketEntry(fileEntry.indexName, fileEntry.fileName, -1L, null);
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.position;
    }

    public long length() {
        return this.fileEntry.getSize();
    }

    public byte readByte() throws IOException {
        this.loadBucketIfNeeded();
        ++this.position;
        return this.bucketEntry.data[this.currentBucketPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.loadBucketIfNeeded();
        if (len <= this.dir.getBucketSize() - this.currentBucketPosition) {
            if (len > 0) {
                System.arraycopy(this.bucketEntry.data, this.currentBucketPosition, b, offset, len);
            }
            this.currentBucketPosition += len;
            this.position += (long)len;
            return;
        }
        while (true) {
            int available;
            int sizeToRead = len <= (available = this.dir.getBucketSize() - this.currentBucketPosition) ? len : available;
            System.arraycopy(this.bucketEntry.data, this.currentBucketPosition, b, offset, sizeToRead);
            offset += sizeToRead;
            this.position += (long)sizeToRead;
            this.currentBucketPosition += sizeToRead;
            if ((len -= sizeToRead) <= 0) break;
            this.loadBucketIfNeeded();
        }
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
    }

    private void loadBucketIfNeeded() throws GigaSpaceDirectoryException {
        this.currentBucketPosition = (int)this.position % this.dir.getBucketSize();
        long bucketIndex = this.position / (long)this.dir.getBucketSize();
        if (bucketIndex == this.bucketEntry.bucketIndex) {
            return;
        }
        this.bucketEntry.data = null;
        this.bucketEntry.bucketIndex = bucketIndex;
        try {
            this.bucketEntry = (FileBucketEntry)this.dir.getSpace().read((Entry)this.bucketEntry, null, 0L);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.fileEntry.indexName, this.fileEntry.fileName, "Failed to read bucket [" + bucketIndex + "]", e);
        }
        if (this.bucketEntry == null) {
            throw new GigaSpaceDirectoryException(this.fileEntry.indexName, this.fileEntry.fileName, "Bucket [" + bucketIndex + "] not found");
        }
        if (this.bucketEntry.data == null) {
            throw new GigaSpaceDirectoryException(this.fileEntry.indexName, this.fileEntry.fileName, "Bucket [" + bucketIndex + "] has no data");
        }
    }

    public Object clone() {
        GigaSpaceIndexInput indexInput = (GigaSpaceIndexInput)((Object)super.clone());
        indexInput.bucketEntry = new FileBucketEntry(this.fileEntry.indexName, this.fileEntry.fileName, -1L, null);
        return indexInput;
    }
}

