/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.config;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.concordion.cubano.config.PropertyLoader;

public class DefaultPropertyLoader
implements PropertyLoader {
    private final Properties properties;
    private final String environment;

    public DefaultPropertyLoader(Properties properties) {
        this.properties = properties;
        this.environment = this.loadEnvironmentProperty();
    }

    private String loadEnvironmentProperty() {
        String environment = System.getProperty("environment", "");
        if (environment.isEmpty()) {
            environment = this.properties.getProperty("environment", "");
        }
        return environment;
    }

    public String getEnvironment() {
        return this.environment;
    }

    @Override
    public String getProperty(String key) {
        String value = this.retrieveProperty(key);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unable to find property %s", key));
        }
        return value;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.retrieveProperty(key);
        if (value.isEmpty()) {
            value = defaultValue == null ? "" : defaultValue;
        }
        return value;
    }

    @Override
    public boolean getPropertyAsBoolean(String key, String defaultValue) {
        String value = this.retrieveProperty(key);
        if (value.isEmpty()) {
            value = defaultValue == null ? "false" : defaultValue;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public int getPropertyAsInteger(String key, String defaultValue) {
        String value = this.retrieveProperty(key);
        if (value.isEmpty()) {
            value = defaultValue == null ? "0" : defaultValue;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Map<String, String> getPropertiesStartingWith(String keyPrefix) {
        return this.getPropertiesStartingWith(keyPrefix, false);
    }

    @Override
    public Map<String, String> getPropertiesStartingWith(String keyPrefix, boolean trimPrefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String propName = (String)en.nextElement();
            String propValue = this.properties.getProperty(propName);
            if (!propName.startsWith(keyPrefix)) continue;
            if (trimPrefix) {
                propName = propName.substring(keyPrefix.length());
            }
            result.put(propName, propValue);
        }
        return result;
    }

    private String retrieveProperty(String key) {
        String value = null;
        if (this.environment != null && !this.environment.isEmpty()) {
            value = this.properties.getProperty(this.environment + "." + key);
        }
        if (value == null) {
            value = this.properties.getProperty(key);
        }
        value = value == null ? "" : value.trim();
        return value;
    }
}

