/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.config;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import org.concordion.cubano.config.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfig.class);
    private boolean proxyIsRequired;
    private String proxyType;
    private String proxyHost;
    private int proxyPort = 0;
    private String proxyUsername = "";
    private String proxyPassword = "";
    private String nonProxyHosts = "";

    ProxyConfig(PropertyLoader propertyLoader) {
        this.proxyIsRequired = propertyLoader.getPropertyAsBoolean("proxy.required", null);
        this.setProxyFromConfigFile(propertyLoader);
        this.setProxyFromSystemProperties();
        this.setProxyFromEnvironmentVariables();
        if (this.proxyIsRequired && this.proxyHost.isEmpty()) {
            throw new IllegalArgumentException("proxy.host has not been set when proxy.required is set to true");
        }
    }

    public boolean isProxyRequired() {
        return this.proxyIsRequired;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyAddress() {
        if (this.proxyHost.isEmpty()) {
            return "";
        }
        if (this.proxyPort == 0 || this.proxyPort == 80) {
            return this.proxyHost;
        }
        return this.proxyHost + ":" + String.valueOf(this.proxyPort);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    private void setProxyFromConfigFile(PropertyLoader propertyLoader) {
        this.proxyType = propertyLoader.getProperty("proxy.type", "");
        this.proxyHost = propertyLoader.getProperty("proxy.host", "");
        if (this.proxyHost.isEmpty()) {
            return;
        }
        LOGGER.debug("Loading Proxy settings from configuration file(s)");
        this.proxyPort = propertyLoader.getPropertyAsInteger("proxy.port", "80");
        this.proxyUsername = propertyLoader.getProperty("proxy.username", "");
        this.proxyPassword = propertyLoader.getProperty("proxy.password", "");
        this.nonProxyHosts = propertyLoader.getProperty("proxy.nonProxyHosts", "");
    }

    private void setProxyFromSystemProperties() {
        if (!this.proxyHost.isEmpty()) {
            return;
        }
        this.proxyHost = System.getProperty("http.proxyHost", "");
        if (this.proxyHost.isEmpty()) {
            return;
        }
        LOGGER.debug("Loading Proxy settings from http.proxy... system properties");
        this.proxyPort = Integer.valueOf(System.getProperty("http.proxyPort", "80"));
        this.proxyUsername = System.getProperty("http.proxyUser", "");
        this.proxyPassword = System.getProperty("http.proxyPassword", "");
        this.nonProxyHosts = System.getProperty("http.nonProxyHosts", "").replaceAll("\\|", ",");
    }

    private void setProxyFromEnvironmentVariables() {
        if (!this.proxyHost.isEmpty()) {
            return;
        }
        URL proxyUrl = this.getProxyUrl();
        if (proxyUrl == null) {
            this.proxyHost = "";
        } else {
            LOGGER.debug("Loading Proxy settings from HTTP_PROXY environment variable(s)");
            this.proxyHost = proxyUrl.getHost();
            this.proxyPort = proxyUrl.getPort();
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null) {
                StringTokenizer st = new StringTokenizer(userInfo, ":");
                try {
                    this.proxyUsername = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
                    this.proxyPassword = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (this.proxyUsername == null || this.proxyUsername.isEmpty()) {
                this.proxyUsername = System.getenv("HTTP_PROXY_USER");
            }
            if (this.proxyPassword == null || this.proxyPassword.isEmpty()) {
                this.proxyPassword = System.getenv("HTTP_PROXY_PASS");
            }
            this.nonProxyHosts = System.getenv("NO_PROXY");
        }
    }

    private URL getProxyUrl() {
        String proxyInput = System.getenv("HTTP_PROXY");
        try {
            if (proxyInput != null) {
                return new URL(proxyInput.matches("^http[s]?://.*$") ? proxyInput : "http://" + proxyInput);
            }
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Invalid proxy url {} in HTTP_PROXY environment variable", (Object)proxyInput, (Object)e);
        }
        return null;
    }
}

