/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.cml.exception.ResourceIsNoCMLModelException;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class CMLResource
implements Resource {
    private final Resource resource;

    public CMLResource(Resource resource) {
        if (resource.getContents().isEmpty()) {
            this.throwResourceIsNoCMLModelException(resource);
        }
        if (!(resource.getContents().get(0) instanceof ContextMappingModel)) {
            this.throwResourceIsNoCMLModelException(resource);
        }
        this.resource = resource;
        this.resource.setTrackingModification(true);
    }

    public ContextMappingModel getContextMappingModel() {
        List contextMappingModels = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)this.resource.getAllContents(), ContextMappingModel.class));
        return (ContextMappingModel)contextMappingModels.get(0);
    }

    private void throwResourceIsNoCMLModelException(Resource resource) {
        if (resource.getURI() != null) {
            throw new ResourceIsNoCMLModelException(resource.getURI());
        }
        throw new ResourceIsNoCMLModelException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMLResource)) {
            return false;
        }
        CMLResource otherResource = (CMLResource)obj;
        return this.resource.getURI().equals(otherResource.resource.getURI());
    }

    public XtextResource getXtextResource() {
        if (!(this.resource instanceof XtextResource)) {
            throw new ContextMapperApplicationException("The given resource (" + this.resource.getURI().toString() + ") is not an XtextResource!");
        }
        return (XtextResource)this.resource;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public EList<Adapter> eAdapters() {
        return this.resource.eAdapters();
    }

    public boolean eDeliver() {
        return this.resource.eDeliver();
    }

    public void eSetDeliver(boolean deliver) {
        this.resource.eSetDeliver(deliver);
    }

    public void eNotify(Notification notification) {
        this.resource.eNotify(notification);
    }

    public ResourceSet getResourceSet() {
        return this.resource.getResourceSet();
    }

    public URI getURI() {
        return this.resource.getURI();
    }

    public void setURI(URI uri) {
        this.resource.setURI(uri);
    }

    public long getTimeStamp() {
        return this.resource.getTimeStamp();
    }

    public void setTimeStamp(long timeStamp) {
        this.resource.setTimeStamp(timeStamp);
    }

    public EList<EObject> getContents() {
        return this.resource.getContents();
    }

    public TreeIterator<EObject> getAllContents() {
        return this.resource.getAllContents();
    }

    public String getURIFragment(EObject eObject) {
        return this.resource.getURIFragment(eObject);
    }

    public EObject getEObject(String uriFragment) {
        return this.resource.getEObject(uriFragment);
    }

    public void save(Map<?, ?> options) throws IOException {
        this.resource.save(options);
    }

    public void load(Map<?, ?> options) throws IOException {
        this.resource.load(options);
    }

    public void save(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.resource.save(outputStream, options);
    }

    public void load(InputStream inputStream, Map<?, ?> options) throws IOException {
        this.resource.load(inputStream, options);
    }

    public boolean isTrackingModification() {
        return this.resource.isTrackingModification();
    }

    public void setTrackingModification(boolean isTrackingModification) {
        this.resource.setTrackingModification(isTrackingModification);
    }

    public boolean isModified() {
        return this.resource.isModified();
    }

    public void setModified(boolean isModified) {
        this.resource.setModified(isModified);
    }

    public boolean isLoaded() {
        return this.resource.isLoaded();
    }

    public void unload() {
        this.resource.unload();
    }

    public void delete(Map<?, ?> options) throws IOException {
        this.resource.delete(options);
    }

    public EList<Resource.Diagnostic> getErrors() {
        return this.resource.getErrors();
    }

    public EList<Resource.Diagnostic> getWarnings() {
        return this.resource.getWarnings();
    }
}

