/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.contextMappingDSL;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BoundedContextType implements Enumerator
{
    UNDEFINED(0, "UNDEFINED", "UNDEFINED"),
    FEATURE(1, "FEATURE", "FEATURE"),
    APPLICATION(2, "APPLICATION", "APPLICATION"),
    SYSTEM(3, "SYSTEM", "SYSTEM"),
    TEAM(4, "TEAM", "TEAM");

    public static final int UNDEFINED_VALUE = 0;
    public static final int FEATURE_VALUE = 1;
    public static final int APPLICATION_VALUE = 2;
    public static final int SYSTEM_VALUE = 3;
    public static final int TEAM_VALUE = 4;
    private static final BoundedContextType[] VALUES_ARRAY;
    public static final List<BoundedContextType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BoundedContextType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BoundedContextType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BoundedContextType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BoundedContextType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BoundedContextType get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return FEATURE;
            }
            case 2: {
                return APPLICATION;
            }
            case 3: {
                return SYSTEM;
            }
            case 4: {
                return TEAM;
            }
        }
        return null;
    }

    private BoundedContextType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BoundedContextType[]{UNDEFINED, FEATURE, APPLICATION, SYSTEM, TEAM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

