/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.freemarker.FreemarkerTextGenerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class GenericContentGenerator
extends AbstractContextMappingModelGenerator {
    private File freemarkerTemplateFile;
    private String targetFileName;
    private Map<String, Object> customDataMap = new HashMap<String, Object>();

    public void setFreemarkerTemplateFile(File freemarkerTemplateFile) {
        this.freemarkerTemplateFile = freemarkerTemplateFile;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void registerCustomModelProperty(String propertyName, Object object) {
        this.customDataMap.put(propertyName, object);
    }

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        if (this.freemarkerTemplateFile == null) {
            throw new GeneratorInputException("The freemarker template has not been set!");
        }
        if (!this.freemarkerTemplateFile.exists()) {
            throw new GeneratorInputException("The file '" + this.freemarkerTemplateFile.getAbsolutePath().toString() + "' does not exist!");
        }
        if (this.targetFileName == null || "".equals(this.targetFileName)) {
            throw new GeneratorInputException("Please provide a name for the file that shall be generated.");
        }
        FreemarkerTextGenerator generator = new FreemarkerTextGenerator(this.freemarkerTemplateFile);
        for (Map.Entry<String, Object> customDataEntry : this.customDataMap.entrySet()) {
            generator.registerCustomModelProperty(customDataEntry.getKey(), customDataEntry.getValue());
        }
        fsa.generateFile(this.targetFileName, (CharSequence)generator.generate(model));
    }
}

