/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import ch.hsr.servicecutter.api.ServiceCutter;
import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.ServiceCutterContextBuilder;
import ch.hsr.servicecutter.api.SolverConfigurationFactory;
import ch.hsr.servicecutter.api.model.EntityRelationDiagram;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.api.model.UserRepresentationContainer;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.scorer.Scorer;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.contextmapper.dsl.config.ServiceCutterConfigHandler;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.ServiceCutterUserRepresentationsGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.servicecutter.input.converter.ContextMappingModelToServiceCutterERDConverter;
import org.contextmapper.dsl.generator.servicecutter.input.converter.SCLToUserRepresentationsConverter;
import org.contextmapper.dsl.generator.servicecutter.output.converter.ServiceCutterOutputToContextMappingModelConverter;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class NewServiceCutContextMapGenerator
extends AbstractContextMappingModelGenerator {
    private File projectDir;

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.checkPreconditions(model);
        String fileBaseName = inputFileURI.trimFileExtension().lastSegment();
        EntityRelationDiagram erdInput = new ContextMappingModelToServiceCutterERDConverter().convert(fileBaseName, model);
        ServiceCutterContextBuilder contextBuilder = new ServiceCutterContextBuilder(erdInput);
        SolverConfiguration solverConfig = this.getSolverConfiguration();
        contextBuilder.withCustomSolverConfiguration(solverConfig);
        contextBuilder.withUserRepresentations(this.getUserRepresentations(inputFileURI));
        ServiceCutterContext context = contextBuilder.build();
        SolverResult result = new ServiceCutter(context).generateDecomposition();
        ContextMappingModel newServiceCutModel = new ServiceCutterOutputToContextMappingModelConverter(this.contextMappingModel, context, this.getSCLModel(inputFileURI).eResource().getURI()).convert(result);
        int counter = 1;
        String baseFileName = inputFileURI.trimFileExtension().lastSegment() + "_" + solverConfig.getAlgorithm().toString().replace(" ", "_") + "_Cut_";
        URI fileName = inputFileURI.trimFileExtension().trimSegments(1).appendSegment(baseFileName + counter).appendFileExtension("cml");
        while (this.resourceSet.getURIConverter().exists(fileName, null)) {
            fileName = inputFileURI.trimFileExtension().trimSegments(1).appendSegment(baseFileName + ++counter).appendFileExtension("cml");
        }
        Resource resource = this.resourceSet.createResource(fileName);
        resource.getContents().add((Object)newServiceCutModel);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Saving CML model was not possible.", e);
        }
        fsa.generateFile(fileName.trimFileExtension().lastSegment() + ".gv", (CharSequence)this.generateGraphvizScoringRepresentation(context));
    }

    private String generateGraphvizScoringRepresentation(ServiceCutterContext context) {
        StringBuilder sb = new StringBuilder();
        Scorer scorer = new Scorer(context.getCouplingInstances(), context.getNanoEntities());
        Map scores = scorer.getScores(key -> context.getSolverConfiguration().getPriorityForCouplingCriterion(key).toValue());
        sb.append("graph G {" + System.lineSeparator());
        for (Map.Entry entry : scores.entrySet()) {
            double score;
            if (((EntityPair)entry.getKey()).nanoentityA == null || ((EntityPair)entry.getKey()).nanoentityB == null || !((score = ((Map)entry.getValue()).values().stream().mapToDouble(Score::getPrioritizedScore).sum()) > 0.0)) continue;
            String nameA = ((EntityPair)entry.getKey()).nanoentityA.getContextName();
            String nameB = ((EntityPair)entry.getKey()).nanoentityB.getContextName();
            sb.append("  \"" + nameA + "\" -- \"" + nameB + "\" [weight=" + score + ",label=" + score + "]; // { ");
            List scoreEntries = ((Map)entry.getValue()).entrySet().stream().map(scoreEntry -> (String)scoreEntry.getKey() + ": " + ((Score)scoreEntry.getValue()).getPriority() + " * " + ((Score)scoreEntry.getValue()).getScore() + " = " + ((Score)scoreEntry.getValue()).getPrioritizedScore()).collect(Collectors.toList());
            sb.append(String.join((CharSequence)", ", scoreEntries));
            sb.append(" }");
            sb.append(System.lineSeparator());
        }
        sb.append("}").append(System.lineSeparator());
        return sb.toString();
    }

    public void setProjectDirectory(File projectDir) {
        if (!projectDir.exists()) {
            throw new ContextMapperApplicationException("The project directory '" + projectDir.getAbsolutePath() + "' does not exist!");
        }
        this.projectDir = projectDir;
    }

    private SolverConfiguration getSolverConfiguration() {
        if (this.projectDir != null) {
            ServiceCutterConfigHandler configHandler = new ServiceCutterConfigHandler(this.projectDir);
            return configHandler.getServiceCutterSolverConfiguration();
        }
        return new SolverConfigurationFactory().createDefaultConfiguration();
    }

    private UserRepresentationContainer getUserRepresentations(URI inputFileURI) {
        this.updateUserRepresentations();
        return new SCLToUserRepresentationsConverter().convert(this.getSCLModel(inputFileURI));
    }

    private ServiceCutterUserRepresentationsModel getSCLModel(URI inputFileURI) {
        URI sclURI = inputFileURI.trimFileExtension().appendFileExtension("scl");
        Resource sclResource = this.resourceSet.getResource(sclURI, true);
        return (ServiceCutterUserRepresentationsModel)sclResource.getContents().get(0);
    }

    private void updateUserRepresentations() {
        new ServiceCutterUserRepresentationsGenerator().doGenerate(this.contextMappingModel.eResource(), this.fsa, this.context);
    }

    public void checkPreconditions(ContextMappingModel model) {
        if (this.collectAttributes(model).isEmpty()) {
            throw new GeneratorInputException("Your model should at least contain one Bounded Context with entities and some attributes. Without attributes (Service Cutter nanoentities) we cannot calculate service cuts.");
        }
    }

    private List<Attribute> collectAttributes(ContextMappingModel model) {
        ArrayList attributes = Lists.newArrayList();
        for (BoundedContext bc : model.getBoundedContexts()) {
            attributes.addAll(EcoreUtil2.getAllContentsOfType((EObject)bc, Attribute.class));
        }
        return attributes;
    }
}

