/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import ch.hsr.servicecutter.api.model.EntityRelation;
import ch.hsr.servicecutter.api.model.EntityRelationDiagram;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.servicecutter.input.converter.ContextMappingModelToServiceCutterERDConverter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class ServiceCutterInputGenerator
extends AbstractContextMappingModelGenerator {
    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        String modelName = inputFileURI.trimFileExtension().lastSegment();
        ContextMappingModelToServiceCutterERDConverter converter = new ContextMappingModelToServiceCutterERDConverter();
        EntityRelationDiagram erd = converter.convert(modelName, model);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule customEntityRelationSerializerModule = new SimpleModule("CustomEntityRelationSerializer", new Version(1, 0, 0, null, null, null));
        customEntityRelationSerializerModule.addSerializer((JsonSerializer)new CustomEntityRelationSerializer(EntityRelation.class));
        objectMapper.registerModule((Module)customEntityRelationSerializerModule);
        try {
            fsa.generateFile(modelName + ".json", (CharSequence)objectMapper.writeValueAsString((Object)erd));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("JSON conversion error occured!", e);
        }
    }

    private class CustomEntityRelationSerializer
    extends StdSerializer<EntityRelation> {
        protected CustomEntityRelationSerializer(Class<EntityRelation> t) {
            super(t);
        }

        public void serialize(EntityRelation value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("origin", value.getOrigin().getName());
            jsonGenerator.writeStringField("destination", value.getDestination().getName());
            jsonGenerator.writeStringField("type", value.getType().toString());
            jsonGenerator.writeEndObject();
        }
    }
}

