/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.contextmapper.dsl.generator.AbstractFreemarkerTextCreator;
import org.contextmapper.dsl.generator.mdsl.ProtectedRegionContext;
import org.contextmapper.dsl.generator.mdsl.model.DataType;
import org.contextmapper.dsl.generator.mdsl.model.EndpointClient;
import org.contextmapper.dsl.generator.mdsl.model.EndpointContract;
import org.contextmapper.dsl.generator.mdsl.model.EndpointProvider;
import org.contextmapper.dsl.generator.mdsl.model.ServiceSpecification;

public class MDSLAPIDescriptionCreator
extends AbstractFreemarkerTextCreator<ServiceSpecification> {
    private static final String TEMPLATE_NAME = "mdsl-api-description.ftl";
    private ProtectedRegionContext protectedRegionContext;
    private String inputFileName;

    public MDSLAPIDescriptionCreator(ProtectedRegionContext protectedRegionContext, String inputFileName) {
        this.protectedRegionContext = protectedRegionContext;
    }

    @Override
    protected void preprocessing(ServiceSpecification modelObject) {
        this.updateServiceSpecification4ProtectedRegions(modelObject);
    }

    @Override
    protected void registerModelObjects(Map<String, Object> root, ServiceSpecification modelObject) {
        root.put("serviceSpecification", modelObject);
        root.put("timestampString", this.getTimestampString(this.inputFileName));
    }

    @Override
    protected String getTemplateName() {
        return TEMPLATE_NAME;
    }

    @Override
    protected Class<?> getTemplateClass() {
        return MDSLAPIDescriptionCreator.class;
    }

    protected String getTimestampString(String inputFileName) {
        return "Generated from DDD Context Map '" + inputFileName + "' at " + new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()) + ".";
    }

    private void updateServiceSpecification4ProtectedRegions(ServiceSpecification serviceSpecification) {
        serviceSpecification.setDataTypeProtectedRegion(this.protectedRegionContext.getProtectedDataTypeRegion());
        serviceSpecification.setEndpointProtectedRegion(this.protectedRegionContext.getProtectedEndpointRegion());
        serviceSpecification.setProviderProtectedRegion(this.protectedRegionContext.getProtectedProviderRegion());
        serviceSpecification.setClientProtectedRegion(this.protectedRegionContext.getProtectedClientRegion());
        for (String protectedDataTye : this.protectedRegionContext.getDataTypeIdentifiers()) {
            Optional<DataType> dataType = serviceSpecification.getDataTypes().stream().filter(dt -> dt.getName().equals(protectedDataTye)).findAny();
            if (!dataType.isPresent()) continue;
            serviceSpecification.getDataTypes().remove(dataType.get());
        }
        for (String protectedEndpoint : this.protectedRegionContext.getEndpointIdentifiers()) {
            Optional<EndpointContract> endpoint = serviceSpecification.getEndpoints().stream().filter(ec -> ec.getName().equals(protectedEndpoint)).findAny();
            if (!endpoint.isPresent()) continue;
            serviceSpecification.getEndpoints().remove(endpoint.get());
        }
        for (String protectedProvider : this.protectedRegionContext.getProviderIdentifiers()) {
            Optional<EndpointProvider> provider = serviceSpecification.getProviders().stream().filter(p -> p.getName().equals(protectedProvider)).findAny();
            if (!provider.isPresent()) continue;
            serviceSpecification.getProviders().remove(provider.get());
        }
        for (String protectedClient : this.protectedRegionContext.getClientIdentifiers()) {
            Optional<EndpointClient> client = serviceSpecification.getClients().stream().filter(cl -> cl.getName().equals(protectedClient)).findAny();
            if (!client.isPresent()) continue;
            serviceSpecification.getClients().remove(client.get());
        }
    }
}

