/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.mdsl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.generator.mdsl.MDSLNameEncoder;
import org.contextmapper.dsl.generator.mdsl.model.DataType;
import org.contextmapper.dsl.generator.mdsl.model.DataTypeAttribute;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;

public class MDSLDataTypeCreator {
    private static final String BASE_TYPE = "Object";
    private static final String PARAMETER_NAME_EXTENSION = "Parameter";
    private Map<String, DataType> dataTypeMapping = Maps.newTreeMap();
    private MDSLNameEncoder mdslNameEncoder = new MDSLNameEncoder();

    public DataType createMDSLDataType(ComplexType type) {
        String dataTypeName = this.getDataTypeName(type);
        String mdslTypeName = this.getMDSLDataTypeName(dataTypeName);
        if (this.isPrimitiveType(mdslTypeName)) {
            return this.createPrimitiveDataType(mdslTypeName);
        }
        return this.createComplexType(this.mdslNameEncoder.encodeName(dataTypeName), type);
    }

    public DataType createMDSLDataType4ParameterList(String methodName, List<Parameter> parameters) {
        String dataTypeName = this.mdslNameEncoder.encodeName(methodName + PARAMETER_NAME_EXTENSION);
        if (this.dataTypeMapping.containsKey(dataTypeName)) {
            return this.dataTypeMapping.get(dataTypeName);
        }
        DataType dataType = new DataType();
        dataType.setName(dataTypeName);
        dataType.addAttributes(this.createAttributes4ParameterList(parameters));
        this.dataTypeMapping.put(dataTypeName, dataType);
        return dataType;
    }

    public Collection<DataType> getAllDataTypes() {
        return this.dataTypeMapping.values();
    }

    private DataType createPrimitiveDataType(String primitiveTypeName) {
        DataType primitiveDataType = new DataType();
        primitiveDataType.setIsPrimitiveType(true);
        primitiveDataType.setName(primitiveTypeName);
        return primitiveDataType;
    }

    private DataType createComplexType(String complexTypeName, ComplexType type) {
        if (this.dataTypeMapping.containsKey(complexTypeName) && !this.dataTypeMapping.get(complexTypeName).isAbstractDataType()) {
            return this.dataTypeMapping.get(complexTypeName);
        }
        DataType dataType = new DataType();
        dataType.setName(complexTypeName);
        this.dataTypeMapping.put(complexTypeName, dataType);
        if (type.getDomainObjectType() != null && type.getDomainObjectType() instanceof Enum) {
            dataType.setIsEnumType(true);
            dataType.addAttributes(this.createAttributesForEnum((Enum)type.getDomainObjectType()));
        } else if (type.getDomainObjectType() != null && type.getDomainObjectType() instanceof DomainObject) {
            DomainObject object = (DomainObject)type.getDomainObjectType();
            dataType.addAttributes(this.createAttributes4AttributeList(this.getDomainObjectAttributes(object)));
            dataType.addAttributes(this.createAttributes4ReferencesList(this.getDomainObjectReferences(object)));
        }
        return dataType;
    }

    private String getDataTypeName(ComplexType type) {
        String dataTypeName = type.getType();
        if (type.getDomainObjectType() != null) {
            dataTypeName = type.getDomainObjectType().getName();
        }
        return dataTypeName;
    }

    private boolean isPrimitiveType(String dataTypeName) {
        return !BASE_TYPE.equals(dataTypeName);
    }

    private String getMDSLDataTypeName(String dataTypeName) {
        if ("boolean".equals(dataTypeName.toLowerCase())) {
            return "D<bool>";
        }
        if ("String".equals(dataTypeName)) {
            return "D<string>";
        }
        if ("int".equals(dataTypeName) || "Integer".equals(dataTypeName)) {
            return "D<int>";
        }
        if ("long".equals(dataTypeName.toLowerCase())) {
            return "D<long>";
        }
        if ("double".equals(dataTypeName.toLowerCase())) {
            return "D<double>";
        }
        if ("Blob".equals(dataTypeName)) {
            return "D<raw>";
        }
        if ("Date".equals(dataTypeName)) {
            return "D<string>";
        }
        return BASE_TYPE;
    }

    private List<DataTypeAttribute> createAttributesForEnum(Enum enumm) {
        ArrayList<DataTypeAttribute> attributes = new ArrayList<DataTypeAttribute>();
        for (EnumValue value : enumm.getValues()) {
            DataTypeAttribute attribute = new DataTypeAttribute();
            attribute.setName(this.mdslNameEncoder.encodeName(value.getName()));
            attribute.setType(this.mdslNameEncoder.encodeName(enumm.getName()));
            attributes.add(attribute);
        }
        return attributes;
    }

    private List<DataTypeAttribute> createAttributes4AttributeList(List<Attribute> attributes) {
        ArrayList mdslAttributes = Lists.newArrayList();
        for (Attribute attribute : attributes) {
            mdslAttributes.add(this.createAttribute(attribute.getName(), this.mapAbstractDataType(attribute.getType()), this.isCollection(attribute.getCollectionType()), attribute.isNullable()));
        }
        return mdslAttributes;
    }

    private List<DataTypeAttribute> createAttributes4ReferencesList(List<Reference> references) {
        ArrayList mdslAttributes = Lists.newArrayList();
        for (Reference reference : references) {
            DataType referencedType = this.createMDSLDataType(this.createComplexTypeForReference(reference));
            mdslAttributes.add(this.createAttribute(reference.getName(), referencedType.getName(), this.isCollection(reference.getCollectionType()), reference.isNullable()));
        }
        return mdslAttributes;
    }

    private List<DataTypeAttribute> createAttributes4ParameterList(List<Parameter> parameters) {
        ArrayList mdslAttributes = Lists.newArrayList();
        for (Parameter parameter : parameters) {
            DataType referencedType = this.createMDSLDataType(parameter.getParameterType());
            mdslAttributes.add(this.createAttribute(parameter.getName(), referencedType.getName(), this.isCollection(parameter.getParameterType().getCollectionType()), false));
        }
        return mdslAttributes;
    }

    private DataTypeAttribute createAttribute(String attributeName, String attributeType, boolean isCollection, boolean isNullable) {
        DataTypeAttribute attribute = new DataTypeAttribute();
        attribute.setName(this.mdslNameEncoder.encodeName(attributeName));
        attribute.setType(this.mdslNameEncoder.encodeName(attributeType));
        attribute.setIsCollection(isCollection);
        attribute.setIsNullable(isNullable);
        return attribute;
    }

    private String mapAbstractDataType(String dataTypeName) {
        String mdslTypeName = this.getMDSLDataTypeName(dataTypeName);
        if (this.isPrimitiveType(mdslTypeName)) {
            return mdslTypeName;
        }
        String encodedDataTypeName = this.mdslNameEncoder.encodeName(dataTypeName);
        if (this.dataTypeMapping.containsKey(encodedDataTypeName)) {
            return this.dataTypeMapping.get(encodedDataTypeName).getName();
        }
        DataType newDataType = new DataType();
        newDataType.setName(this.mdslNameEncoder.encodeName(encodedDataTypeName));
        this.dataTypeMapping.put(encodedDataTypeName, newDataType);
        return encodedDataTypeName;
    }

    private List<Attribute> getDomainObjectAttributes(DomainObject domainObject) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        DomainObject extendsType = this.getExtendsType(domainObject);
        while (extendsType != null) {
            attributes.addAll((Collection<Attribute>)extendsType.getAttributes());
            extendsType = this.getExtendsType(extendsType);
        }
        attributes.addAll((Collection<Attribute>)domainObject.getAttributes());
        return attributes;
    }

    private List<Reference> getDomainObjectReferences(DomainObject domainObject) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        DomainObject extendsType = this.getExtendsType(domainObject);
        while (extendsType != null) {
            references.addAll((Collection<Reference>)extendsType.getReferences());
            extendsType = this.getExtendsType(extendsType);
        }
        references.addAll((Collection<Reference>)domainObject.getReferences());
        return references;
    }

    private DomainObject getExtendsType(DomainObject domainObject) {
        if (domainObject instanceof Entity) {
            return ((Entity)domainObject).getExtends();
        }
        if (domainObject instanceof CommandEvent) {
            return ((CommandEvent)domainObject).getExtends();
        }
        if (domainObject instanceof DomainEvent) {
            return ((DomainEvent)domainObject).getExtends();
        }
        if (domainObject instanceof ValueObject) {
            return ((ValueObject)domainObject).getExtends();
        }
        return null;
    }

    private ComplexType createComplexTypeForReference(Reference reference) {
        ComplexType type = TacticdslFactory.eINSTANCE.createComplexType();
        type.setCollectionType(reference.getCollectionType());
        type.setDomainObjectType(reference.getDomainObjectType());
        return type;
    }

    private boolean isCollection(CollectionType collectionType) {
        return collectionType != CollectionType.NONE;
    }
}

