/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.Application;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.DomainPart;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class PlantUMLBoundedContextClassDiagramCreator
extends AbstractPlantUMLClassDiagramCreator<BoundedContext>
implements PlantUMLDiagramCreator<BoundedContext> {
    @Override
    protected void printDiagramContent(BoundedContext boundedContext) {
        this.relationships = Lists.newArrayList();
        this.extensions = Lists.newArrayList();
        this.domainObjects = EcoreUtil2.getAllContentsOfType((EObject)boundedContext, SimpleDomainObject.class);
        if (this.domainObjects.size() <= 0) {
            this.printEmptyDiagramNote();
            return;
        }
        for (SculptorModule module : boundedContext.getModules()) {
            this.printModule(module);
        }
        for (Aggregate aggregate : boundedContext.getAggregates()) {
            this.printAggregate(aggregate, 0);
        }
        if (boundedContext.getApplication() != null) {
            this.printApplication(boundedContext.getApplication(), 0);
        }
        this.printReferences(0);
        this.printLegend(boundedContext);
    }

    private void printLegend(BoundedContext boundedContext) {
        List<Subdomain> subdomains = this.getSubdomains((List<DomainPart>)boundedContext.getImplementedDomainParts());
        if (subdomains.isEmpty() && boundedContext.getRefinedBoundedContext() == null) {
            return;
        }
        this.sb.append("legend left");
        this.linebreak();
        if (boundedContext.getRefinedBoundedContext() != null) {
            this.sb.append("  ").append("This Bounded Context '").append(boundedContext.getName()).append("' refines the '").append(boundedContext.getRefinedBoundedContext().getName()).append("' Bounded Context.");
            this.linebreak();
        }
        for (Subdomain subdomain : subdomains) {
            if (subdomain.getEntities().isEmpty()) {
                this.sb.append("  ").append("This bounded context implements the subdomain '" + subdomain.getName() + "'.");
            } else {
                this.sb.append("  ").append("This bounded context implements the subdomain '" + subdomain.getName() + "', which contains the following entities:");
            }
            this.linebreak();
            for (Entity entity : subdomain.getEntities()) {
                this.sb.append("  ").append(" - ").append(entity.getName());
                this.linebreak();
            }
        }
        this.sb.append("end legend");
        this.linebreak();
    }

    private void printEmptyDiagramNote() {
        this.sb.append("note").append(" ").append("\"").append("Sorry, we cannot generate a class diagram for this Bounded Context. There are no Aggregates or none of the Aggregates contain any domain objects (entities, value objects or domain events).").append("\"").append(" as EmptyDiagramError");
        this.linebreak();
    }

    private void printApplication(Application application, int indentation) {
        this.printIndentation(indentation);
        String name = StringUtils.isNotEmpty((CharSequence)application.getName()) ? application.getName() : "Application";
        this.sb.append("package ").append("\"'").append(name).append("'").append("\"").append(" <<Rectangle>> ").append("{");
        this.linebreak();
        if (!application.getFlows().isEmpty()) {
            this.printIndentation(indentation + 1);
            this.sb.append("legend left");
            this.linebreak();
            this.printIndentation(indentation + 2);
            this.sb.append("This application layer contains flow definitions (visualization available via BPMN Sketch Miner).");
            this.linebreak();
            this.printIndentation(indentation + 1);
            this.sb.append("end legend");
            this.linebreak();
        }
        for (DomainEvent event : application.getEvents()) {
            this.printDomainObject(event, indentation + 1);
        }
        for (CommandEvent command : application.getCommands()) {
            this.printDomainObject(command, indentation + 1);
        }
        for (Service service : application.getServices()) {
            this.printService(service, indentation + 1);
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private List<Subdomain> getSubdomains(List<DomainPart> domainParts) {
        ArrayList subdomains = Lists.newArrayList();
        domainParts.forEach(domainPart -> {
            if (domainPart instanceof Domain) {
                subdomains.addAll(((Domain)domainPart).getSubdomains());
            } else {
                subdomains.add((Subdomain)domainPart);
            }
        });
        return subdomains;
    }
}

