/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.quickfixes.tactic;

import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;

public class ExtractIDValueObjectQuickFix
implements CMLQuickFix<Attribute> {
    @Override
    public void applyQuickfix(Attribute attribute) {
        if (!(attribute.eContainer() instanceof DomainObject)) {
            throw new ContextMapperApplicationException("This Quickfix is not applicable on the selected object.");
        }
        DomainObject parentObject = (DomainObject)attribute.eContainer();
        ValueObject vo = this.createValueObject(attribute);
        this.addVOToContainer(parentObject, vo);
        this.fixReference(attribute, parentObject, vo);
    }

    private void addVOToContainer(DomainObject object, ValueObject vo) {
        if (object.eContainer() instanceof Aggregate) {
            ((Aggregate)object.eContainer()).getDomainObjects().add((Object)vo);
        } else if (object.eContainer() instanceof SculptorModule) {
            ((SculptorModule)object.eContainer()).getDomainObjects().add((Object)vo);
        }
    }

    private ValueObject createValueObject(Attribute attribute) {
        ValueObject vo = TacticdslFactory.eINSTANCE.createValueObject();
        String voName = attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1);
        vo.setName(voName);
        Attribute idAttribute = TacticdslFactory.eINSTANCE.createAttribute();
        idAttribute.setName("id");
        idAttribute.setType(attribute.getType());
        vo.getAttributes().add((Object)idAttribute);
        return vo;
    }

    private void fixReference(Attribute originalAttribute, DomainObject object, ValueObject vo) {
        object.getAttributes().remove((Object)originalAttribute);
        Reference reference = TacticdslFactory.eINSTANCE.createReference();
        reference.setName(originalAttribute.getName());
        reference.setCollectionType(CollectionType.NONE);
        reference.setDomainObjectType(vo);
        object.getReferences().add((Object)reference);
    }

    @Override
    public String getName() {
        return "Extract Value Object";
    }

    @Override
    public String getDescription() {
        return "Extracts a Value Object for the given identifier attribute.";
    }
}

