/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;

public class ContextMappingModelHelper {
    private ContextMap contextMap;

    public ContextMappingModelHelper(ContextMap contextMap) {
        this.contextMap = contextMap;
    }

    public List<Relationship> findAnyRelationshipsBetweenTwoContexts(BoundedContext bc1, BoundedContext bc2) {
        ArrayList relationships = Lists.newArrayList();
        for (Relationship relationship : this.contextMap.getRelationships()) {
            UpstreamDownstreamRelationship upDownRelationship;
            if (relationship instanceof SymmetricRelationship) {
                SymmetricRelationship symRelationship = (SymmetricRelationship)relationship;
                if ((!symRelationship.getParticipant1().getName().equals(bc1.getName()) || !symRelationship.getParticipant2().getName().equals(bc2.getName())) && (!symRelationship.getParticipant1().getName().equals(bc2.getName()) || !symRelationship.getParticipant2().getName().equals(bc1.getName()))) continue;
                relationships.add(symRelationship);
                continue;
            }
            if (!(relationship instanceof UpstreamDownstreamRelationship) || (!(upDownRelationship = (UpstreamDownstreamRelationship)relationship).getUpstream().getName().equals(bc1.getName()) || !upDownRelationship.getDownstream().getName().equals(bc2.getName())) && (!upDownRelationship.getUpstream().getName().equals(bc2.getName()) || !upDownRelationship.getDownstream().getName().equals(bc1.getName()))) continue;
            relationships.add(upDownRelationship);
        }
        return relationships;
    }

    public List<Relationship> findAnyRelationshipsInvolvingContext(BoundedContext bc) {
        ArrayList relationships = Lists.newArrayList();
        for (Relationship relationship : this.contextMap.getRelationships()) {
            UpstreamDownstreamRelationship upDownRelationship;
            if (relationship instanceof SymmetricRelationship) {
                SymmetricRelationship symRelationship = (SymmetricRelationship)relationship;
                if (!symRelationship.getParticipant1().getName().endsWith(bc.getName()) && !symRelationship.getParticipant2().getName().equals(bc.getName())) continue;
                relationships.add(symRelationship);
                continue;
            }
            if (!(relationship instanceof UpstreamDownstreamRelationship) || !(upDownRelationship = (UpstreamDownstreamRelationship)relationship).getUpstream().getName().equals(bc.getName()) && !upDownRelationship.getDownstream().getName().equals(bc.getName())) continue;
            relationships.add(upDownRelationship);
        }
        return relationships;
    }

    public boolean replaceBCInAllRelationships(BoundedContext originalBC, BoundedContext replacementBC) {
        boolean replacedAtLeastInOneRelationship = false;
        for (Relationship relationship : this.contextMap.getRelationships()) {
            if (relationship instanceof SymmetricRelationship) {
                SymmetricRelationship symRelationship = (SymmetricRelationship)relationship;
                if (symRelationship.getParticipant1().getName().equals(originalBC.getName())) {
                    symRelationship.setParticipant1(replacementBC);
                    replacedAtLeastInOneRelationship = true;
                }
                if (!symRelationship.getParticipant2().getName().equals(originalBC.getName())) continue;
                symRelationship.setParticipant2(replacementBC);
                replacedAtLeastInOneRelationship = true;
                continue;
            }
            if (!(relationship instanceof UpstreamDownstreamRelationship)) continue;
            UpstreamDownstreamRelationship upDownRelationship = (UpstreamDownstreamRelationship)relationship;
            if (upDownRelationship.getDownstream().getName().equals(originalBC.getName())) {
                upDownRelationship.setDownstream(replacementBC);
                replacedAtLeastInOneRelationship = true;
            }
            if (!upDownRelationship.getUpstream().getName().equals(originalBC.getName())) continue;
            upDownRelationship.setUpstream(replacementBC);
            replacedAtLeastInOneRelationship = true;
        }
        if (replacedAtLeastInOneRelationship && !this.contextMap.getBoundedContexts().stream().map(bc -> bc.getName()).collect(Collectors.toSet()).contains(replacementBC.getName())) {
            this.contextMap.getBoundedContexts().add((Object)replacementBC);
        }
        return replacedAtLeastInOneRelationship;
    }

    public void moveExposedAggregatesToNewRelationshipsIfNeeded(List<String> movedAggregates, BoundedContext newBoundedContext) {
        for (Relationship relationship : new LinkedList<Relationship>((Collection<Relationship>)this.contextMap.getRelationships())) {
            if (!(relationship instanceof UpstreamDownstreamRelationship)) continue;
            this.moveExposedAggregates4RelationshipIfNeeded((UpstreamDownstreamRelationship)relationship, movedAggregates, newBoundedContext);
        }
    }

    private void moveExposedAggregates4RelationshipIfNeeded(UpstreamDownstreamRelationship relationship, List<String> movedAggregates, BoundedContext newBoundedContext) {
        List exposedAggregates = relationship.getUpstreamExposedAggregates().stream().map(a -> a.getName()).collect(Collectors.toList());
        List aggregatesToMove = exposedAggregates.stream().distinct().filter(movedAggregates::contains).collect(Collectors.toList());
        if (aggregatesToMove.isEmpty()) {
            return;
        }
        UpstreamDownstreamRelationship newRelationship = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        newRelationship.setUpstream(newBoundedContext);
        newRelationship.setDownstream(relationship.getDownstream());
        newRelationship.setImplementationTechnology(relationship.getImplementationTechnology());
        newRelationship.getUpstreamRoles().addAll(relationship.getUpstreamRoles());
        newRelationship.getDownstreamRoles().addAll(relationship.getDownstreamRoles());
        for (Aggregate aggregate : new LinkedList<Aggregate>((Collection<Aggregate>)relationship.getUpstreamExposedAggregates())) {
            if (!aggregatesToMove.contains(aggregate.getName())) continue;
            relationship.getUpstreamExposedAggregates().remove((Object)aggregate);
            newRelationship.getUpstreamExposedAggregates().add((Object)aggregate);
        }
        if (!this.contextMap.getBoundedContexts().contains((Object)newBoundedContext)) {
            this.contextMap.getBoundedContexts().add((Object)newBoundedContext);
        }
        this.contextMap.getRelationships().add((Object)newRelationship);
    }
}

