/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class DeriveBoundedContextFromSubdomains
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private CMLModelObjectsResolvingHelper objectResolver;
    private Set<String> subdomainIds = Sets.newHashSet();
    private String boundedContextName;

    public DeriveBoundedContextFromSubdomains(String boundedContextName, Set<String> subdomainIds) {
        this.boundedContextName = boundedContextName;
        this.subdomainIds = subdomainIds;
        this.objectResolver = new CMLModelObjectsResolvingHelper(this.model);
    }

    @Override
    protected void doRefactor() {
        Set<Subdomain> selectedSubdomains = this.collectSubdomains();
        if (selectedSubdomains.isEmpty()) {
            throw new RefactoringInputException("Please provide at least one subdomain name that can be found in the given CML model.");
        }
        BoundedContext bc = this.createOrGetBoundedContext(this.boundedContextName);
        bc.setDomainVisionStatement("This Bounded Context realizes the following subdomains: " + String.join((CharSequence)", ", selectedSubdomains.stream().map(sd -> sd.getName()).collect(Collectors.toList())));
        bc.setType(BoundedContextType.FEATURE);
        for (Subdomain subdomain : selectedSubdomains) {
            this.addElementToEList(bc.getImplementedDomainParts(), subdomain);
            this.createAggregate4Subdomain(subdomain, bc);
        }
    }

    private void createAggregate4Subdomain(Subdomain subdomain, BoundedContext bc) {
        Aggregate aggregate = this.createOrGetAggregate(bc, this.getAggregateName(subdomain.getName() + "Aggregate", bc));
        aggregate.setComment("/* This Aggregate contains the entities and services of the '" + subdomain.getName() + "' subdomain." + System.lineSeparator() + "\t * TODO: You can now refactor the Aggregate, for example by using the 'Split Aggregate by Entities' architectural refactoring." + System.lineSeparator() + "\t * TODO: Add attributes and operations to the entities." + System.lineSeparator() + "\t * TODO: Add operations to the services." + System.lineSeparator() + "\t * Find examples and further instructions on our website: https://contextmapper.org/docs/rapid-ooad/ */");
        this.createEntities(subdomain, aggregate);
        this.createServices(subdomain, aggregate);
    }

    private String getAggregateName(String initialName, BoundedContext bc) {
        Set currentBCAggregates = bc.getAggregates().stream().map(agg -> agg.getName()).collect(Collectors.toSet());
        if (currentBCAggregates.contains(initialName)) {
            return initialName;
        }
        String contextName = initialName;
        Set<String> allAggregateNames = this.collectAllAggregateNames();
        allAggregateNames.removeAll(currentBCAggregates);
        int counter = 2;
        while (allAggregateNames.contains(contextName)) {
            contextName = initialName + "_" + counter;
            ++counter;
        }
        return contextName;
    }

    private Set<String> collectAllAggregateNames() {
        HashSet aggregateNames = Sets.newHashSet();
        for (BoundedContext bc : this.getAllBoundedContexts()) {
            aggregateNames.addAll(bc.getAggregates().stream().map(agg -> agg.getName()).collect(Collectors.toSet()));
        }
        return aggregateNames;
    }

    private void createEntities(Subdomain subdomain, Aggregate aggregate) {
        Entity bcEntity;
        for (Entity sdEntity : subdomain.getEntities()) {
            if (this.entityAlreadyExistsInOtherContext(sdEntity.getName())) {
                throw new ContextMapperApplicationException("Cannot derive Bounded Context. Another context with an Entity of the name \"" + sdEntity.getName() + "\" already exists.");
            }
            bcEntity = this.createOrGetEntity(aggregate, sdEntity.getName());
            bcEntity.setAggregateRoot(false);
            this.copyAttributes(sdEntity, bcEntity);
            String idAttributeName = sdEntity.getName().toLowerCase() + "Id";
            if (bcEntity.getAttributes().stream().filter(a -> idAttributeName.equals(a.getName())).findFirst().isPresent()) continue;
            Attribute idAttribute = TacticdslFactory.eINSTANCE.createAttribute();
            idAttribute.setName(idAttributeName);
            idAttribute.setType("String");
            idAttribute.setKey(true);
            this.addElementToEList(bcEntity.getAttributes(), idAttribute);
        }
        for (Entity sdEntity : subdomain.getEntities()) {
            bcEntity = this.createOrGetEntity(aggregate, sdEntity.getName());
            this.copyReferences(sdEntity, bcEntity, (List<SimpleDomainObject>)aggregate.getDomainObjects());
        }
    }

    private boolean entityAlreadyExistsInOtherContext(String entityName) {
        HashSet existingEntities = Sets.newHashSet();
        Set boundedContexts = this.getAllBoundedContexts().stream().filter(bc -> !bc.getName().equals(this.boundedContextName)).collect(Collectors.toSet());
        for (BoundedContext bc2 : boundedContexts) {
            existingEntities.addAll(Sets.newHashSet((Iterator)IteratorExtensions.filter((Iterator)EcoreUtil2.eAll((EObject)bc2), Entity.class)).stream().map(e -> e.getName()).collect(Collectors.toSet()));
        }
        return existingEntities.contains(entityName);
    }

    private void copyAttributes(Entity source, Entity target) {
        Set existingAttrs = target.getAttributes().stream().map(attr -> attr.getName()).collect(Collectors.toSet());
        for (Attribute sourceAttr : source.getAttributes()) {
            if (existingAttrs.contains(sourceAttr.getName())) continue;
            this.addElementToEList(target.getAttributes(), (Attribute)EcoreUtil.copy((EObject)sourceAttr));
        }
    }

    private void copyReferences(Entity source, Entity target, List<SimpleDomainObject> referenceableObjects) {
        Set existingRefs = target.getReferences().stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        for (Reference sourceRef : source.getReferences()) {
            if (existingRefs.contains(sourceRef.getName())) continue;
            Reference newReference = TacticdslFactory.eINSTANCE.createReference();
            newReference.setName(sourceRef.getName());
            newReference.setCollectionType(sourceRef.getCollectionType());
            newReference.setDomainObjectType(referenceableObjects.stream().filter(o -> o.getName().equals(sourceRef.getDomainObjectType().getName())).findFirst().get());
            this.addElementToEList(target.getReferences(), newReference);
        }
    }

    private void createServices(Subdomain subdomain, Aggregate aggregate) {
        for (Service sdService : subdomain.getServices()) {
            Service bcService = this.createOrGetService(aggregate, sdService.getName());
            bcService.setDoc(sdService.getDoc());
            bcService.setHint(sdService.getHint());
            this.copyAndEnhanceOperations(aggregate, sdService, bcService);
        }
    }

    private void copyAndEnhanceOperations(Aggregate aggregate, Service source, Service target) {
        Set existingOperations = target.getOperations().stream().map(o -> o.getName()).collect(Collectors.toSet());
        for (ServiceOperation sourceOperation : source.getOperations()) {
            if (existingOperations.contains(sourceOperation.getName())) continue;
            ServiceOperation targetOperation = TacticdslFactory.eINSTANCE.createServiceOperation();
            targetOperation.setName(sourceOperation.getName());
            targetOperation.setDelegateHolder(sourceOperation.getDelegateHolder());
            targetOperation.setHint(sourceOperation.getHint());
            targetOperation.setDoc(sourceOperation.getDoc());
            targetOperation.setPublish(sourceOperation.getPublish());
            targetOperation.setThrows(sourceOperation.getThrows());
            targetOperation.setVisibility(sourceOperation.getVisibility());
            if (sourceOperation.getReturnType() == null) {
                targetOperation.setReturnType(this.getReturnType4Operation(aggregate, sourceOperation.getName()));
            }
            if (sourceOperation.getParameters().isEmpty()) {
                ComplexType parameterType = this.getParameterType4Operation(aggregate, sourceOperation.getName());
                this.addElementToEList(targetOperation.getParameters(), this.createParameter(this.getParameterName4ComplexType(parameterType), parameterType));
            }
            this.addElementToEList(target.getOperations(), targetOperation);
        }
    }

    private BoundedContext createOrGetBoundedContext(String boundedContextName) {
        Optional<BoundedContext> optContext = this.getAllBoundedContexts().stream().filter(bc -> boundedContextName.equals(bc.getName())).findFirst();
        if (optContext.isPresent()) {
            return optContext.get();
        }
        BoundedContext newBC = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
        newBC.setName(boundedContextName);
        this.addElementToEList(this.rootResource.getContextMappingModel().getBoundedContexts(), newBC);
        return newBC;
    }

    private Aggregate createOrGetAggregate(BoundedContext bc, String aggregateName) {
        Optional<Aggregate> optAggregate = bc.getAggregates().stream().filter(agg -> aggregateName.equals(agg.getName())).findFirst();
        if (optAggregate.isPresent()) {
            return optAggregate.get();
        }
        for (SculptorModule module : bc.getModules()) {
            optAggregate = module.getAggregates().stream().filter(agg -> aggregateName.equals(agg.getName())).findFirst();
            if (!optAggregate.isPresent()) continue;
            return optAggregate.get();
        }
        Aggregate newAggregate = ContextMappingDSLFactory.eINSTANCE.createAggregate();
        newAggregate.setName(aggregateName);
        this.addElementToEList(bc.getAggregates(), newAggregate);
        return newAggregate;
    }

    private Entity createOrGetEntity(Aggregate aggregate, String entityName) {
        Optional<Entity> optEntity = aggregate.getDomainObjects().stream().filter(o -> o instanceof Entity && entityName.equals(o.getName())).map(o -> (Entity)o).findFirst();
        if (optEntity.isPresent()) {
            return optEntity.get();
        }
        Entity newEntity = TacticdslFactory.eINSTANCE.createEntity();
        newEntity.setName(entityName);
        this.addElementToEList(aggregate.getDomainObjects(), newEntity);
        return newEntity;
    }

    private Service createOrGetService(Aggregate aggregate, String serviceName) {
        Optional<Service> optService = aggregate.getServices().stream().filter(s -> serviceName.equals(s.getName())).findFirst();
        if (optService.isPresent()) {
            return optService.get();
        }
        Service newService = TacticdslFactory.eINSTANCE.createService();
        newService.setName(serviceName);
        this.addElementToEList(aggregate.getServices(), newService);
        return newService;
    }

    private ComplexType getReturnType4Operation(Aggregate aggregate, String operationName) {
        Entity correspondingEntity = this.resolveEntity4OperationByFeatures(aggregate, operationName);
        if (correspondingEntity != null && operationName.startsWith("create")) {
            return this.createComplexType("String");
        }
        if (correspondingEntity != null && (operationName.startsWith("read") || operationName.startsWith("get"))) {
            return this.createComplexType(correspondingEntity, CollectionType.SET);
        }
        if (correspondingEntity != null && operationName.startsWith("update")) {
            return this.createComplexType("String");
        }
        return this.createComplexType("boolean");
    }

    private ComplexType getParameterType4Operation(Aggregate aggregate, String operationName) {
        Entity correspondingEntity = this.resolveEntity4OperationByFeatures(aggregate, operationName);
        if (correspondingEntity != null && (operationName.startsWith("read") || operationName.startsWith("get"))) {
            return this.createComplexType("String", CollectionType.SET);
        }
        if (correspondingEntity != null && operationName.startsWith("delete")) {
            return this.createComplexType("String");
        }
        if (correspondingEntity != null) {
            return this.createComplexType(correspondingEntity);
        }
        return this.createComplexType(operationName.substring(0, 1).toUpperCase() + operationName.substring(1) + "Input");
    }

    private ComplexType createComplexType(String type) {
        ComplexType complexType = TacticdslFactory.eINSTANCE.createComplexType();
        complexType.setType(type);
        return complexType;
    }

    private ComplexType createComplexType(String type, CollectionType collectionType) {
        ComplexType complexType = TacticdslFactory.eINSTANCE.createComplexType();
        complexType.setType(type);
        complexType.setCollectionType(collectionType);
        return complexType;
    }

    private ComplexType createComplexType(SimpleDomainObject object) {
        ComplexType complexType = TacticdslFactory.eINSTANCE.createComplexType();
        complexType.setDomainObjectType(object);
        return complexType;
    }

    private ComplexType createComplexType(SimpleDomainObject object, CollectionType collectionType) {
        ComplexType complexType = this.createComplexType(object);
        complexType.setCollectionType(collectionType);
        return complexType;
    }

    private String getParameterName4ComplexType(ComplexType complexType) {
        String parameterName = "input";
        if (complexType.getDomainObjectType() != null) {
            parameterName = complexType.getDomainObjectType().getName();
        } else if (complexType.getType() != null && "String".equals(complexType.getType())) {
            parameterName = "id";
        } else if (complexType.getType() != null && !"".equals(complexType.getType())) {
            parameterName = complexType.getType();
        }
        return parameterName.substring(0, 1).toLowerCase() + parameterName.substring(1);
    }

    private Parameter createParameter(String name, ComplexType type) {
        Parameter parameter = TacticdslFactory.eINSTANCE.createParameter();
        parameter.setName(name);
        parameter.setParameterType(type);
        return parameter;
    }

    private Set<Subdomain> collectSubdomains() {
        HashSet allSubdomains = Sets.newHashSet();
        for (Domain domain : this.getAllDomains()) {
            allSubdomains.addAll(domain.getSubdomains());
        }
        HashSet subdomains = Sets.newHashSet();
        for (String subdomainId : this.subdomainIds) {
            Optional<Subdomain> optSubdomain = allSubdomains.stream().filter(sd -> subdomainId.equals(sd.getName())).findFirst();
            if (!optSubdomain.isPresent()) continue;
            subdomains.add(optSubdomain.get());
        }
        return subdomains;
    }

    private Entity resolveEntity4OperationByFeatures(Aggregate aggregate2Search, String operationName) {
        BoundedContext bc = this.objectResolver.resolveBoundedContext(aggregate2Search);
        Set<Feature> features = this.objectResolver.resolveFeatures(bc);
        for (Feature feature : features) {
            if (!operationName.equals(feature.getVerb() + feature.getEntity()) && !operationName.endsWith(feature.getEntity())) continue;
            return aggregate2Search.getDomainObjects().stream().filter(o -> o instanceof Entity).map(o -> (Entity)o).filter(o -> o.getName().equals(feature.getEntity())).findFirst().get();
        }
        return null;
    }
}

