/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.Optional;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.ContextSplittingIntegrationType;
import org.contextmapper.dsl.refactoring.RefactoringHelper;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DeriveFrontendAndBackendSystemsFromFeature
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String featureBoundedContextName;
    private ContextSplittingIntegrationType relationshipType;
    private boolean deriveViewModelInFrontend = true;
    private String frontendName;
    private String backendName;
    private String frontendImplTechnology;
    private String backendImplTechnology;
    private String relationshipImplTechnology;
    private RefactoringHelper helper;

    public DeriveFrontendAndBackendSystemsFromFeature(String featureBoundedContextName, ContextSplittingIntegrationType relationshipType) {
        this.featureBoundedContextName = featureBoundedContextName;
        this.relationshipType = relationshipType;
        this.frontendName = featureBoundedContextName + "Frontend";
        this.backendName = featureBoundedContextName + "Backend";
        this.helper = new RefactoringHelper(this);
    }

    @Override
    protected void doRefactor() {
        this.checkPreconditions();
        this.deleteExistingContexts();
        BoundedContext featureContext = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.featureBoundedContextName)).findFirst().get();
        BoundedContext backend = (BoundedContext)EcoreUtil.copy((EObject)featureContext);
        backend.setType(BoundedContextType.SYSTEM);
        backend.setName(this.backendName);
        backend.setImplementationTechnology(this.backendImplTechnology);
        this.addElementToEList(this.model.getBoundedContexts(), backend);
        this.helper.adjustAggregateAndModuleNames(backend, "Backend");
        BoundedContext frontend = (BoundedContext)EcoreUtil.copy((EObject)featureContext);
        frontend.setType(BoundedContextType.SYSTEM);
        frontend.setName(this.frontendName);
        frontend.setImplementationTechnology(this.frontendImplTechnology);
        this.addElementToEList(this.model.getBoundedContexts(), frontend);
        if (!this.deriveViewModelInFrontend) {
            frontend.getAggregates().clear();
            frontend.getModules().clear();
            this.addElementToEList(frontend.getAggregates(), this.createSampleViewModelAggregate());
        } else {
            this.helper.adjustAggregateAndModuleNames(frontend, "ViewModel");
        }
        ContextMap map = this.createOrGetContextMap();
        UpstreamDownstreamRelationship relationship = ContextMappingDSLFactory.eINSTANCE.createUpstreamDownstreamRelationship();
        relationship.setDownstream(frontend);
        relationship.setUpstream(backend);
        relationship.getUpstreamRoles().add((Object)UpstreamRole.PUBLISHED_LANGUAGE);
        relationship.getDownstreamRoles().add((Object)this.getDownstreamRole());
        relationship.setImplementationTechnology(this.relationshipImplTechnology);
        this.addElementsToEList(relationship.getUpstreamExposedAggregates(), this.helper.collectAggregates(backend));
        this.addElementToEList(map.getBoundedContexts(), frontend);
        this.addElementToEList(map.getBoundedContexts(), backend);
        this.addElementToEList(map.getRelationships(), relationship);
    }

    private void deleteExistingContexts() {
        Optional<BoundedContext> optFrontend = this.model.getBoundedContexts().stream().filter(bc -> bc.getName().equals(this.frontendName)).findFirst();
        Optional<BoundedContext> optBackend = this.model.getBoundedContexts().stream().filter(bc -> bc.getName().equals(this.backendName)).findFirst();
        if (optFrontend.isPresent()) {
            this.removeContextFromMap(optFrontend.get());
        }
        if (optBackend.isPresent()) {
            this.removeContextFromMap(optBackend.get());
        }
    }

    private void removeContextFromMap(BoundedContext bc) {
        if (this.model.getMap() != null) {
            ContextMappingModelHelper mappingHelper = new ContextMappingModelHelper(this.model.getMap());
            for (Relationship relationship : mappingHelper.findAnyRelationshipsInvolvingContext(bc)) {
                this.removeElementFromEList(this.model.getMap().getRelationships(), relationship);
            }
            if (this.model.getMap().getBoundedContexts().contains((Object)bc)) {
                this.removeElementFromEList(this.model.getMap().getBoundedContexts(), bc);
            }
        }
        this.removeElementFromEList(this.model.getBoundedContexts(), bc);
    }

    private Aggregate createSampleViewModelAggregate() {
        Aggregate aggregate = ContextMappingDSLFactory.eINSTANCE.createAggregate();
        aggregate.setName("ViewModel");
        aggregate.setComment("/* The view model of this frontend system has not been generated. " + System.lineSeparator() + "\t * TODO: specify the view model now, using Aggregates, Entities, Value Objects, etc. */");
        return aggregate;
    }

    private ContextMap createOrGetContextMap() {
        if (this.model.getMap() != null) {
            return this.model.getMap();
        }
        ContextMap newContextMap = ContextMappingDSLFactory.eINSTANCE.createContextMap();
        this.model.setMap(newContextMap);
        return newContextMap;
    }

    private DownstreamRole getDownstreamRole() {
        if (this.relationshipType == ContextSplittingIntegrationType.ACL) {
            return DownstreamRole.ANTICORRUPTION_LAYER;
        }
        return DownstreamRole.CONFORMIST;
    }

    private void checkPreconditions() {
        Optional<BoundedContext> optFeatureBC = this.getAllBoundedContexts().stream().filter(bc -> bc.getName().equals(this.featureBoundedContextName)).findFirst();
        if (!optFeatureBC.isPresent()) {
            throw new RefactoringInputException("A Bounded Context with the name '" + this.featureBoundedContextName + "' does not exist!");
        }
        BoundedContext featureBC = optFeatureBC.get();
        if (featureBC.getType() != BoundedContextType.FEATURE && featureBC.getType() != BoundedContextType.APPLICATION) {
            throw new RefactoringInputException("The Bounded Context '" + this.featureBoundedContextName + "' is not of the type FEATURE!");
        }
    }

    public void deriveViewModelInFronted(boolean derive) {
        this.deriveViewModelInFrontend = derive;
    }

    public void setFrontendName(String frontendName) {
        this.frontendName = frontendName;
    }

    public void setBackendName(String backendName) {
        this.backendName = backendName;
    }

    public void setFrontendImplementationTechnology(String technology) {
        this.frontendImplTechnology = technology;
    }

    public void setBackendImplementationTechnology(String technology) {
        this.backendImplTechnology = technology;
    }

    public void setRelationshipImplTechnology(String technology) {
        this.relationshipImplTechnology = technology;
    }
}

