/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class SplitAggregateByEntitiesRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String aggregateName;
    private List<Aggregate> newAggregates;

    public SplitAggregateByEntitiesRefactoring(String aggregateName) {
        this.aggregateName = aggregateName;
        this.newAggregates = new LinkedList<Aggregate>();
    }

    @Override
    protected void doRefactor() {
        Aggregate inputAggregate = this.getSelectedAggregate();
        if (inputAggregate == null) {
            return;
        }
        List entities = EcoreUtil2.eAllOfType((EObject)inputAggregate, Entity.class);
        if (entities.size() == 1) {
            return;
        }
        for (int i = 1; i < entities.size(); ++i) {
            this.moveEntityToNewAggregate(inputAggregate, (Entity)entities.get(i));
        }
        ((Entity)entities.get(0)).setAggregateRoot(true);
        this.postProcessing();
    }

    private void moveEntityToNewAggregate(Aggregate inputAggregate, Entity movingEntity) {
        Aggregate newAggregate = ContextMappingDSLFactory.eINSTANCE.createAggregate();
        newAggregate.setName(this.getUniqueAggregateName(movingEntity.getName()));
        this.removeElementFromEList(inputAggregate.getDomainObjects(), movingEntity);
        this.addElementToEList(newAggregate.getDomainObjects(), movingEntity);
        movingEntity.setAggregateRoot(true);
        if (inputAggregate.eContainer() instanceof SculptorModule) {
            SculptorModule container = (SculptorModule)inputAggregate.eContainer();
            this.addElementToEList(container.getAggregates(), newAggregate);
        } else {
            BoundedContext container = (BoundedContext)inputAggregate.eContainer();
            this.addElementToEList(container.getAggregates(), newAggregate);
        }
        this.newAggregates.add(newAggregate);
    }

    private void postProcessing() {
        for (ContextMap contextMap : this.getAllContextMaps()) {
            this.addNewAggregatesToExposedAggregatesIfOriginalIsExposed(contextMap);
        }
    }

    private Aggregate getSelectedAggregate() {
        List allAggregates = EcoreUtil2.getAllContentsOfType((EObject)this.model, Aggregate.class);
        List aggregatesWithInputName = allAggregates.stream().filter(agg -> agg.getName().equals(this.aggregateName)).collect(Collectors.toList());
        if (aggregatesWithInputName.isEmpty()) {
            return null;
        }
        return (Aggregate)aggregatesWithInputName.get(0);
    }

    private void addNewAggregatesToExposedAggregatesIfOriginalIsExposed(ContextMap contextMap) {
        for (Relationship relationship : contextMap.getRelationships()) {
            UpstreamDownstreamRelationship upDownRelationship;
            if (!(relationship instanceof UpstreamDownstreamRelationship) || !(upDownRelationship = (UpstreamDownstreamRelationship)relationship).getUpstreamExposedAggregates().stream().map(a -> a.getName()).collect(Collectors.toList()).contains(this.aggregateName)) continue;
            this.addElementsToEList(upDownRelationship.getUpstreamExposedAggregates(), this.newAggregates);
        }
    }

    private String getUniqueAggregateName(String entityName) {
        String name = entityName;
        Set allAggregateNames = EcoreUtil2.eAllOfType((EObject)this.model, Aggregate.class).stream().map(a -> a.getName()).collect(Collectors.toSet());
        int i = 2;
        while (allAggregateNames.contains(name)) {
            name = entityName + "_" + i;
            ++i;
        }
        return name;
    }
}

