/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.CommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.DomainEventProductionStep;
import org.contextmapper.dsl.contextMappingDSL.EitherCommandOrOperation;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.OperationInvokation;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class ApplicationFlowSemanticsValidator
extends AbstractDeclarativeValidator {
    public static final String SKETCH_MINER_INFO_ID = "open-flow-in-sketch-miner";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void commandOrOperationMustBeDefinedInSameContext(EitherCommandOrOperation commandOrOperation) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)commandOrOperation));
        BoundedContext currentContext = helper.resolveBoundedContext(commandOrOperation);
        BoundedContext referencedContext = null;
        String name = null;
        if (commandOrOperation.getCommand() != null) {
            referencedContext = helper.resolveBoundedContext(commandOrOperation.getCommand());
            name = commandOrOperation.getCommand().getName();
            if (currentContext == null || referencedContext == null) {
                return;
            }
            if (!currentContext.getName().equals(referencedContext.getName())) {
                this.error(String.format("The command or operation '%s' is not part of the '%s' Bounded Context. Please ensure that your workflow only uses commands, operations and events that are part of the same Bounded Context.", name, currentContext.getName()), commandOrOperation, (EStructuralFeature)ContextMappingDSLPackage.Literals.EITHER_COMMAND_OR_OPERATION__COMMAND);
            }
        } else {
            referencedContext = helper.resolveBoundedContext(commandOrOperation.getOperation());
            name = commandOrOperation.getOperation().getName();
            if (referencedContext == null || !currentContext.getName().equals(referencedContext.getName())) {
                this.error(String.format("The command or operation '%s' is not part of the '%s' Bounded Context. Please ensure that your workflow only uses commands, operations and events that are part of the same Bounded Context.", name, currentContext.getName()), commandOrOperation, (EStructuralFeature)ContextMappingDSLPackage.Literals.EITHER_COMMAND_OR_OPERATION__OPERATION);
            }
        }
    }

    @Check
    public void commandInvokationMustReferCommandInSameContext(CommandInvokation commandInvokation) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)commandInvokation));
        BoundedContext currentContext = helper.resolveBoundedContext(commandInvokation);
        for (CommandEvent commandEvent : commandInvokation.getCommands()) {
            BoundedContext commandContext = helper.resolveBoundedContext((EObject)commandEvent);
            if (commandContext != null && currentContext.getName().equals(commandContext.getName())) continue;
            this.error(String.format("The command or operation '%s' is not part of the '%s' Bounded Context. Please ensure that your workflow only uses commands, operations and events that are part of the same Bounded Context.", commandEvent.getName(), currentContext.getName()), commandInvokation, (EStructuralFeature)ContextMappingDSLPackage.Literals.COMMAND_INVOKATION__COMMANDS, commandInvokation.getCommands().indexOf((Object)commandEvent));
        }
    }

    @Check
    public void operationInvokationMustReferCommandInSameContext(OperationInvokation operationInvokation) {
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)operationInvokation));
        BoundedContext currentContext = helper.resolveBoundedContext(operationInvokation);
        for (ServiceOperation operation : operationInvokation.getOperations()) {
            BoundedContext commandContext = helper.resolveBoundedContext(operation);
            if (commandContext != null && currentContext.getName().equals(commandContext.getName())) continue;
            this.error(String.format("The command or operation '%s' is not part of the '%s' Bounded Context. Please ensure that your workflow only uses commands, operations and events that are part of the same Bounded Context.", operation.getName(), currentContext.getName()), operationInvokation, (EStructuralFeature)ContextMappingDSLPackage.Literals.OPERATION_INVOKATION__OPERATIONS, operationInvokation.getOperations().indexOf((Object)operation));
        }
    }

    @Check
    public void checkThatStateTransitionStatesBelongToAggregate(DomainEventProductionStep step) {
        if (step.getAggregate() == null) {
            return;
        }
        if (step.getStateTransition() == null) {
            return;
        }
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)step));
        Set<String> aggregateStates = helper.resolveAggregateStates(step.getAggregate());
        for (EnumValue value : step.getStateTransition().getFrom()) {
            if (aggregateStates.contains(value.getName())) continue;
            this.error(String.format("'%s' is not a state of the Aggregate '%s'.", value.getName(), step.getAggregate().getName()), step.getStateTransition(), (EStructuralFeature)TacticdslPackage.Literals.STATE_TRANSITION__FROM, step.getStateTransition().getFrom().indexOf((Object)value));
        }
        for (EnumValue value : step.getStateTransition().getTarget().getTo().stream().map(s -> s.getValue()).collect(Collectors.toList())) {
            if (aggregateStates.contains(value.getName())) continue;
            this.error(String.format("'%s' is not a state of the Aggregate '%s'.", value.getName(), step.getAggregate().getName()), step.getStateTransition().getTarget(), (EStructuralFeature)TacticdslPackage.Literals.STATE_TRANSITION_TARGET__TO, step.getStateTransition().getTarget().getTo().indexOf((Object)value));
        }
    }

    @Check
    public void sketchMinerLink(Flow flow) {
        if (!flow.getSteps().isEmpty()) {
            this.info("Do you want to vizualize this flow? You can open it in BPMN Sketch Miner ...", flow, (EStructuralFeature)ContextMappingDSLPackage.Literals.FLOW__NAME, SKETCH_MINER_INFO_ID, new String[0]);
        }
    }
}

