/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLPackage;
import org.contextmapper.dsl.contextMappingDSL.CustomerSupplierRelationship;
import org.contextmapper.dsl.contextMappingDSL.DownstreamRole;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SymmetricRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UpstreamRole;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class BoundedContextRelationshipSemanticsValidator
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void customerSupplierRolesValidator(CustomerSupplierRelationship relationship) {
        if (relationship.getUpstreamRoles().contains((Object)UpstreamRole.OPEN_HOST_SERVICE)) {
            this.error("The OPEN-HOST SERVICE pattern is not applicable for a Customer-Supplier relationship.", relationship, (EStructuralFeature)ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__UPSTREAM_ROLES);
        }
        if (relationship.getDownstreamRoles().contains((Object)DownstreamRole.ANTICORRUPTION_LAYER)) {
            this.warning("Are you sure you need an ANTICORRUPTION LAYER here? This pattern should not be necessarily needed in a Customer-Supplier relationship.", relationship, (EStructuralFeature)ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__DOWNSTREAM_ROLES);
        }
        if (relationship.getDownstreamRoles().contains((Object)DownstreamRole.CONFORMIST)) {
            this.error("The CONFORMIST pattern is not applicable for a Customer-Supplier relationship.", relationship, (EStructuralFeature)ContextMappingDSLPackage.Literals.UPSTREAM_DOWNSTREAM_RELATIONSHIP__DOWNSTREAM_ROLES);
        }
    }

    @Check
    public void prohibitSelfRelationship(ContextMap contextMap) {
        int relationshipIndex = 0;
        for (Relationship relationship : contextMap.getRelationships()) {
            BoundedContext context2;
            BoundedContext context1;
            if (relationship instanceof SymmetricRelationship) {
                context1 = ((SymmetricRelationship)relationship).getParticipant1();
                context2 = ((SymmetricRelationship)relationship).getParticipant2();
            } else {
                context1 = ((UpstreamDownstreamRelationship)relationship).getUpstream();
                context2 = ((UpstreamDownstreamRelationship)relationship).getDownstream();
            }
            if (context1 == context2) {
                this.error(String.format("Bounded context relationships must be declared between two different bounded contexts.", new Object[0]), contextMap, (EStructuralFeature)ContextMappingDSLPackage.Literals.CONTEXT_MAP__RELATIONSHIPS, relationshipIndex);
            }
            ++relationshipIndex;
        }
    }
}

