/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.cml.CMLTypeChecker;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class DomainObjectValidator
extends AbstractDeclarativeValidator {
    public static final String ID_IS_PRIMITIVE_CODE = "primitive-id-detected";
    private CMLTypeChecker typeChecker = new CMLTypeChecker();

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void suggestValueObject4ID(Attribute attribute) {
        if (attribute.getName() == null) {
            return;
        }
        if (!attribute.getName().endsWith("Id") && !attribute.getName().endsWith("ID")) {
            return;
        }
        if (!(attribute.eContainer() instanceof Entity)) {
            return;
        }
        if (attribute.eContainer().eContainer() instanceof Subdomain) {
            return;
        }
        if (attribute.getCollectionType() == CollectionType.NONE && this.typeChecker.isPrimitiveType(attribute.getType())) {
            this.info("This attribute seems to be an identifier. Have you thought about creating a Value Object?", attribute, (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NAME, ID_IS_PRIMITIVE_CODE, new String[0]);
        }
    }

    @Check
    public void checkForAmbiguousReferences(Reference reference) {
        if (reference.getDomainObjectType() == null) {
            return;
        }
        List referencedObjects = EcoreUtil2.eAllOfType((EObject)EcoreUtil2.getRootContainer((EObject)reference), SimpleDomainObject.class).stream().filter(o -> o.getName().equals(reference.getDomainObjectType().getName())).collect(Collectors.toList());
        if (referencedObjects.size() > 1) {
            this.warning(String.format("The reference to the type '%s' is ambiguous, since there exist multiple domain objects with that name in your model. We suggest to keep the names of domain objects distinct.", reference.getDomainObjectType().getName()), reference, (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__DOMAIN_OBJECT_TYPE);
        }
    }

    @Check
    public void checkForDuplicateDomainNames(SimpleDomainObject simpleDomainObject) {
        List objects = EcoreUtil2.eAllOfType((EObject)EcoreUtil2.getRootContainer((EObject)simpleDomainObject), SimpleDomainObject.class).stream().filter(o -> o.getName().equals(simpleDomainObject.getName())).collect(Collectors.toList());
        if (objects.size() > 1) {
            this.warning(String.format("The name '%s' is used for multiple domain objects. We suggest to keep the names of domain objects distinct.", simpleDomainObject.getName()), simpleDomainObject, (EStructuralFeature)TacticdslPackage.Literals.SIMPLE_DOMAIN_OBJECT__NAME);
        }
    }

    @Check
    public void checkForInterBCReferencesThatRequireRelationship(Reference reference) {
        if (reference.getDomainObjectType() == null || !(EcoreUtil2.getRootContainer((EObject)reference) instanceof ContextMappingModel)) {
            return;
        }
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)reference));
        SimpleDomainObject containingObject = (SimpleDomainObject)reference.eContainer();
        HashSet domainObjectScope = Sets.newHashSet();
        for (Aggregate aggregate : helper.resolveAllAccessibleAggregates(helper.resolveBoundedContext(containingObject))) {
            domainObjectScope.addAll(EcoreUtil2.eAllOfType((EObject)aggregate, SimpleDomainObject.class).stream().map(o -> o.getName()).collect(Collectors.toSet()));
        }
        if (!domainObjectScope.contains(reference.getDomainObjectType().getName())) {
            this.warning(String.format("The object '%s' is not part of this Bounded Context and not reachable through Context Map relationships. Maybe you want to create a relationship with the context that contains that object?", reference.getDomainObjectType().getName()), reference, (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__DOMAIN_OBJECT_TYPE);
        }
    }
}

