/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.validation;

import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObjectOperation;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.StateTransition;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class TacticDDDOperationsValidator
extends AbstractDeclarativeValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void createErrorIfServiceOperationStateTransitionContainsInvalidState(ServiceOperation operation) {
        this.validateOperationStates(operation, operation.getStateTransition());
    }

    @Check
    public void createErrorIfDomainObjectOperationStateTransitionContainsInvalidState(DomainObjectOperation operation) {
        this.validateOperationStates(operation, operation.getStateTransition());
    }

    private void validateOperationStates(EObject operation, StateTransition stateTransition) {
        if (stateTransition == null) {
            return;
        }
        CMLModelObjectsResolvingHelper helper = new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)operation));
        Aggregate aggregate = helper.resolveAggregate(operation);
        if (aggregate == null) {
            return;
        }
        Set<String> aggregateStates = helper.resolveAggregateStates(aggregate);
        for (EnumValue value : stateTransition.getFrom()) {
            if (aggregateStates.contains(value.getName())) continue;
            this.error(String.format("'%s' is not a state of the Aggregate '%s'.", value.getName(), aggregate.getName()), stateTransition, (EStructuralFeature)TacticdslPackage.Literals.STATE_TRANSITION__FROM, stateTransition.getFrom().indexOf((Object)value));
        }
        for (EnumValue value : stateTransition.getTarget().getTo().stream().map(s -> s.getValue()).collect(Collectors.toList())) {
            if (aggregateStates.contains(value.getName())) continue;
            this.error(String.format("'%s' is not a state of the Aggregate '%s'.", value.getName(), aggregate.getName()), stateTransition.getTarget(), (EStructuralFeature)TacticdslPackage.Literals.STATE_TRANSITION_TARGET__TO, stateTransition.getTarget().getTo().indexOf((Object)value));
        }
    }
}

