/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.tactic.dsl.validation;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.contextmapper.tactic.dsl.TacticDslExtensions;
import org.contextmapper.tactic.dsl.tacticdsl.AnyProperty;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.BasicType;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.DtoAttribute;
import org.contextmapper.tactic.dsl.tacticdsl.DtoReference;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.EnumAttribute;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.Event;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Property;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.Repository;
import org.contextmapper.tactic.dsl.tacticdsl.RepositoryOperation;
import org.contextmapper.tactic.dsl.tacticdsl.Service;
import org.contextmapper.tactic.dsl.tacticdsl.ServiceOperation;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslPackage;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.contextmapper.tactic.dsl.validation.AbstractTacticDDDLanguageValidator;
import org.contextmapper.tactic.dsl.validation.IssueCodes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class TacticDDDLanguageValidator
extends AbstractTacticDDDLanguageValidator
implements IssueCodes {
    private final Pattern DIGITS_PATTERN = Pattern.compile("[0-9]+[0-9]*");
    private final HashSet<String> SUPPORTED_PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("int", "long", "float", "double", "boolean"));
    private final HashSet<String> SUPPORTED_TEMPORAL_TYPES = new HashSet<String>(Arrays.asList("Date", "DateTime", "Timestamp"));
    private final HashSet<String> SUPPORTED_NUMERIC_TYPES = new HashSet<String>(Arrays.asList("int", "long", "float", "double", "Integer", "Long", "Float", "Double", "BigInteger", "BigDecimal"));
    private final HashSet<String> SUPPORTED_BOOLEAN_TYPES = new HashSet<String>(Arrays.asList("Boolean", "boolean"));

    @Check
    public void checkServiceNameStartsWithUpperCase(Service service) {
        boolean _not;
        boolean _tripleEquals;
        String _name = service.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isUpperCase = Character.isUpperCase(service.getName().charAt(0));
        boolean bl2 = _not = !_isUpperCase;
        if (_not) {
            this.warning("The service name should begin with an upper case letter", (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME, "org.sculptor.dsl.validation.issue.capitalized_name", new String[]{service.getName()});
        }
    }

    @Check
    public void checkRepositoryNameStartsWithUpperCase(Repository repository) {
        boolean _not;
        boolean _tripleEquals;
        String _name = repository.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isUpperCase = Character.isUpperCase(repository.getName().charAt(0));
        boolean bl2 = _not = !_isUpperCase;
        if (_not) {
            this.warning("The repository name should begin with an upper case letter", (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME, "org.sculptor.dsl.validation.issue.capitalized_name", new String[]{repository.getName()});
        }
    }

    @Check
    public void checkDomainObjectNameStartsWithUpperCase(SimpleDomainObject domainObject) {
        boolean _not;
        boolean _tripleEquals;
        String _name = domainObject.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isUpperCase = Character.isUpperCase(domainObject.getName().charAt(0));
        boolean bl2 = _not = !_isUpperCase;
        if (_not) {
            this.warning("The domain object name should begin with an upper case letter", (EStructuralFeature)TacticdslPackage.Literals.SIMPLE_DOMAIN_OBJECT__NAME, "org.sculptor.dsl.validation.issue.capitalized_name", new String[]{domainObject.getName()});
        }
    }

    @Check
    public void checkPropertyNameStartsWithLowerCase(AnyProperty prop) {
        boolean _not;
        boolean _tripleEquals;
        String _name = prop.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isLowerCase = Character.isLowerCase(prop.getName().charAt(0));
        boolean bl2 = _not = !_isLowerCase;
        if (_not) {
            this.warning("Attribute/reference should begin with a lower case letter", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NAME, "org.sculptor.dsl.validation.issue.uncapitalized_name", new String[]{prop.getName()});
        }
    }

    @Check
    public void checkParamterNameStartsWithLowerCase(Parameter param) {
        boolean _not;
        boolean _tripleEquals;
        String _name = param.getName();
        boolean bl = _tripleEquals = _name == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isLowerCase = Character.isLowerCase(param.getName().charAt(0));
        boolean bl2 = _not = !_isLowerCase;
        if (_not) {
            this.warning("Parameter should begin with a lower case letter", (EStructuralFeature)TacticdslPackage.Literals.PARAMETER__NAME, "org.sculptor.dsl.validation.issue.uncapitalized_name", new String[]{param.getName()});
        }
    }

    @Check
    public void checkRequired(Property prop) {
        if (prop.isNotChangeable() && prop.isRequired()) {
            this.warning("The combination not changeable and required doesn't make sense, remove required", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__REQUIRED);
        }
    }

    @Check
    public void checkKeyNotChangeable(Property prop) {
        if (prop.isKey() && prop.isNotChangeable()) {
            this.warning("Key property is always not changeable", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NOT_CHANGEABLE);
        }
    }

    @Check
    public void checkKeyRequired(Property prop) {
        if (prop.isKey() && prop.isRequired()) {
            this.warning("Key property is always required", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__REQUIRED);
        }
    }

    @Check
    public void checkCollectionCache(Reference ref) {
        if (ref.isCache() && Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            this.error("Cache is only applicable for collections", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__CACHE);
        }
    }

    @Check
    public void checkInverse(Reference ref) {
        boolean _not_1;
        boolean _not;
        boolean _isInverse = ref.isInverse();
        boolean bl = _not = !_isInverse;
        if (_not) {
            return;
        }
        boolean bl2 = _not_1 = Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE)) && (ref.getOppositeHolder() == null || ref.getOppositeHolder().getOpposite() == null || !Objects.equal((Object)((Object)ref.getOppositeHolder().getOpposite().getCollectionType()), (Object)((Object)CollectionType.NONE)));
        if (_not_1) {
            this.error("Inverse is only applicable for references with cardinality many, or one-to-one", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__INVERSE);
        }
    }

    @Check
    public void checkJoinTable(Reference ref) {
        boolean _not;
        boolean _tripleEquals;
        String _databaseJoinTable = ref.getDatabaseJoinTable();
        boolean bl = _tripleEquals = _databaseJoinTable == null;
        if (_tripleEquals) {
            return;
        }
        if (this.isBidirectionalManyToMany(ref) && ref.getOppositeHolder().getOpposite().getDatabaseJoinTable() != null) {
            this.warning("Define databaseJoinTable only at one side of the many-to-many association", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__DATABASE_JOIN_TABLE);
        }
        boolean bl2 = _not = !this.isBidirectionalManyToMany(ref) && (!this.isUnidirectionalToMany(ref) || ref.isInverse());
        if (_not) {
            this.error("databaseJoinTable is only applicable for bidirectional many-to-many, or unidirectional to-many without inverse", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__DATABASE_JOIN_TABLE);
        }
    }

    @Check
    public void checkJoinColumn(Reference ref) {
        boolean _not;
        boolean _tripleEquals;
        String _databaseJoinColumn = ref.getDatabaseJoinColumn();
        boolean bl = _tripleEquals = _databaseJoinColumn == null;
        if (_tripleEquals) {
            return;
        }
        boolean bl2 = _not = !this.isUnidirectionalToMany(ref) || ref.isInverse();
        if (_not) {
            this.error("databaseJoinColumn is only applicable for unidirectional to-many without inverse", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__DATABASE_JOIN_COLUMN);
        }
    }

    private boolean isUnidirectionalToMany(Reference ref) {
        return !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE)) && ref.getOppositeHolder() == null;
    }

    private boolean isBidirectionalManyToMany(Reference ref) {
        return !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE)) && ref.getOppositeHolder() != null && ref.getOppositeHolder().getOpposite() != null && !Objects.equal((Object)((Object)ref.getOppositeHolder().getOpposite().getCollectionType()), (Object)((Object)CollectionType.NONE));
    }

    @Check
    public void checkNullable(Reference ref) {
        if (ref.isNullable() && !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            CollectionType _collectionType = ref.getCollectionType();
            String _plus = "Nullable isn't applicable for references with cardinality many (" + (Object)((Object)_collectionType);
            String _plus_1 = _plus + ")";
            this.error(_plus_1, (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NULLABLE);
        }
    }

    @Check
    public void checkDatabaseColumnForBidirectionalOneToMany(Reference ref) {
        boolean _tripleEquals;
        String _databaseColumn = ref.getDatabaseColumn();
        boolean bl = _tripleEquals = _databaseColumn == null;
        if (_tripleEquals) {
            return;
        }
        if (!Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE)) && ref.getOppositeHolder() != null && ref.getOppositeHolder().getOpposite() != null && Objects.equal((Object)((Object)ref.getOppositeHolder().getOpposite().getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            this.error("databaseColumn should be defined at the opposite side", (EStructuralFeature)TacticdslPackage.Literals.PROPERTY__DATABASE_COLUMN);
        }
    }

    @Check
    public void checkOpposite(Reference ref) {
        boolean _not;
        if (ref.getOppositeHolder() == null || ref.getOppositeHolder().getOpposite() == null) {
            return;
        }
        boolean bl = _not = ref.getOppositeHolder().getOpposite().getOppositeHolder() == null || !Objects.equal((Object)ref.getOppositeHolder().getOpposite().getOppositeHolder().getOpposite(), (Object)ref);
        if (_not) {
            String _name = ref.getOppositeHolder().getOpposite().getName();
            String _plus = "Opposite should specify this reference as opposite: " + _name;
            String _plus_1 = _plus + " <-> ";
            String _name_1 = ref.getName();
            String _plus_2 = _plus_1 + _name_1;
            this.error(_plus_2, (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__OPPOSITE_HOLDER);
        }
    }

    @Check
    public void checkChangeableCollection(Reference ref) {
        if (ref.isNotChangeable() && !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            this.warning("x-to-many references are never changeable, the content of the collection is always changeable", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NOT_CHANGEABLE);
        }
    }

    @Check
    public void checkOrderBy(Reference ref) {
        if (ref.getOrderBy() != null && !this.isBag(ref) && !this.isList(ref)) {
            this.error("orderBy only applicable for Bag or List collections", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__ORDER_BY);
        }
    }

    @Check
    public void checkOrderColumn(Reference ref) {
        if (ref.isOrderColumn() && !this.isList(ref)) {
            this.error("orderColumn only applicable for List collections", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__ORDER_COLUMN);
        }
    }

    @Check
    public void checkOrderByOrOrderColumn(Reference ref) {
        if (ref.getOrderBy() != null && ref.isOrderColumn()) {
            this.error("use either orderBy or orderColumn for List collections", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__ORDER_BY);
        }
    }

    private boolean isBag(Reference ref) {
        CollectionType _collectionType = ref.getCollectionType();
        return Objects.equal((Object)((Object)_collectionType), (Object)((Object)CollectionType.BAG));
    }

    private boolean isList(Reference ref) {
        CollectionType _collectionType = ref.getCollectionType();
        return Objects.equal((Object)((Object)_collectionType), (Object)((Object)CollectionType.LIST));
    }

    @Check
    public void checkNullableKey(Property prop) {
        if (prop.isKey() && prop.isNullable()) {
            boolean _not;
            EObject parent = prop.eContainer();
            boolean _hasAtLeastOneNotNullableKeyElement = this.hasAtLeastOneNotNullableKeyElement(parent);
            boolean bl = _not = !_hasAtLeastOneNotNullableKeyElement;
            if (_not) {
                this.error("Natural key must not be nullable. Composite keys must have at least one not nullable property.", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NULLABLE);
            }
        }
    }

    private boolean hasAtLeastOneNotNullableKeyElement(EObject parent) {
        int keyCount = 0;
        int nullableKeyCount = 0;
        EList _eContents = parent.eContents();
        for (EObject each : _eContents) {
            boolean _isKey_3;
            if (each instanceof Attribute) {
                boolean _isKey = ((Attribute)each).isKey();
                if (!_isKey) continue;
                ++keyCount;
                boolean _isNullable = ((Attribute)each).isNullable();
                if (!_isNullable) continue;
                ++nullableKeyCount;
                continue;
            }
            if (each instanceof Reference) {
                boolean _isKey_1 = ((Reference)each).isKey();
                if (!_isKey_1) continue;
                ++keyCount;
                boolean _isNullable_1 = ((Reference)each).isNullable();
                if (!_isNullable_1) continue;
                ++nullableKeyCount;
                continue;
            }
            if (each instanceof DtoAttribute) {
                boolean _isKey_2 = ((DtoAttribute)each).isKey();
                if (!_isKey_2) continue;
                ++keyCount;
                boolean _isNullable_2 = ((DtoAttribute)each).isNullable();
                if (!_isNullable_2) continue;
                ++nullableKeyCount;
                continue;
            }
            if (!(each instanceof DtoReference) || !(_isKey_3 = ((DtoReference)each).isKey())) continue;
            ++keyCount;
            boolean _isNullable_3 = ((DtoReference)each).isNullable();
            if (!_isNullable_3) continue;
            ++nullableKeyCount;
        }
        return keyCount - nullableKeyCount >= 1;
    }

    @Check
    public void checkKeyNotManyRefererence(Reference ref) {
        if (ref.isKey() && !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            this.error("Natural key can't be a many refererence.", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__KEY);
        }
    }

    @Check
    public void checkCascade(Reference ref) {
        if (ref.getCascade() != null && ref.getDomainObjectType() instanceof BasicType) {
            this.error("Cascade is not applicable for BasicType", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__CASCADE);
        }
        if (ref.getCascade() != null && ref.getDomainObjectType() instanceof Enum) {
            this.error("Cascade is not applicable for enum", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__CASCADE);
        }
    }

    @Check
    public void checkCache(Reference ref) {
        if (ref.isCache() && ref.getDomainObjectType() instanceof BasicType) {
            this.error("Cache is not applicable for BasicType", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__CACHE);
        }
        if (ref.isCache() && ref.getDomainObjectType() instanceof Enum) {
            this.error("Cache is not applicable for enum", (EStructuralFeature)TacticdslPackage.Literals.REFERENCE__CACHE);
        }
    }

    @Check
    public void checkRepositoryName(Repository repository) {
        if (repository.getName() != null && !repository.getName().endsWith("Repository")) {
            this.error("Name of repository must end with 'Repository'", (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME);
        }
    }

    @Check
    public void checkEnumReference(Reference ref) {
        if (ref.getDomainObjectType() instanceof Enum && !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE))) {
            boolean notPersistentVO;
            boolean bl = notPersistentVO = ref.eContainer() instanceof ValueObject && ((ValueObject)ref.eContainer()).isNotPersistent();
            if (!notPersistentVO) {
                this.error("Collection of enum is not supported", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__COLLECTION_TYPE);
            }
        }
    }

    @Check
    public void checkEnumValues(Enum dslEnum) {
        boolean _isEmpty = dslEnum.getValues().isEmpty();
        if (_isEmpty) {
            this.error("At least one enum value must be defined", (EStructuralFeature)TacticdslPackage.Literals.ENUM__VALUES);
        }
    }

    @Check
    public void checkEnumAttributes(Enum dslEnum) {
        boolean _isEmpty = dslEnum.getValues().isEmpty();
        if (_isEmpty) {
            return;
        }
        boolean _isEmpty_1 = dslEnum.getAttributes().isEmpty();
        if (_isEmpty_1) {
            return;
        }
        int attSize = dslEnum.getAttributes().size();
        EList<EnumValue> _values = dslEnum.getValues();
        for (EnumValue each : _values) {
            int _size = each.getParameters().size();
            boolean _notEquals = _size != attSize;
            if (!_notEquals) continue;
            this.error("Enum attribute not defined", (EStructuralFeature)TacticdslPackage.Literals.ENUM__VALUES);
            return;
        }
    }

    @Check
    public void checkEnumParameter(Enum dslEnum) {
        boolean _isEmpty = dslEnum.getValues().isEmpty();
        if (_isEmpty) {
            return;
        }
        int expectedSize = ((EnumValue)dslEnum.getValues().get(0)).getParameters().size();
        EList<EnumValue> _values = dslEnum.getValues();
        for (EnumValue each : _values) {
            int _size = each.getParameters().size();
            boolean _notEquals = _size != expectedSize;
            if (!_notEquals) continue;
            this.error("Enum values must have same number of parameters", (EStructuralFeature)TacticdslPackage.Literals.ENUM__VALUES);
            return;
        }
    }

    @Check
    public void checkEnumImplicitAttribute(Enum dslEnum) {
        boolean _not;
        boolean _isEmpty = dslEnum.getValues().isEmpty();
        if (_isEmpty) {
            return;
        }
        boolean _isEmpty_1 = dslEnum.getAttributes().isEmpty();
        boolean bl = _not = !_isEmpty_1;
        if (_not) {
            return;
        }
        EList<EnumValue> _values = dslEnum.getValues();
        for (EnumValue each : _values) {
            int _size = each.getParameters().size();
            boolean _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            this.error("Only one implicit value attribute is allowed", (EStructuralFeature)TacticdslPackage.Literals.ENUM__VALUES);
            return;
        }
    }

    @Check
    public void checkEnumAttributeKey(Enum dslEnum) {
        boolean _isEmpty = dslEnum.getValues().isEmpty();
        if (_isEmpty) {
            return;
        }
        int count = 0;
        EList<EnumAttribute> _attributes = dslEnum.getAttributes();
        for (EnumAttribute each : _attributes) {
            boolean _isKey = each.isKey();
            if (!_isKey) continue;
            ++count;
        }
        if (count > 1) {
            this.error("Only one enum attribute can be defined as key", (EStructuralFeature)TacticdslPackage.Literals.ENUM__ATTRIBUTES);
        }
    }

    @Check
    public void checkEnumOrdinal(Enum dslEnum) {
        String hint = dslEnum.getHint();
        if (hint != null && hint.contains("ordinal")) {
            EList<EnumAttribute> _attributes = dslEnum.getAttributes();
            for (EnumAttribute attr : _attributes) {
                boolean _isKey = attr.isKey();
                if (!_isKey) continue;
                this.error("ordinal is not allowed for enums with a key attribute", (EStructuralFeature)TacticdslPackage.Literals.ENUM__ATTRIBUTES);
                return;
            }
            EList<EnumValue> _values = dslEnum.getValues();
            for (EnumValue each : _values) {
                if (each.getParameters().size() != 1 || !dslEnum.getAttributes().isEmpty()) continue;
                this.error("ordinal is not allowed for enum with implicit value", (EStructuralFeature)TacticdslPackage.Literals.ENUM__VALUES);
                return;
            }
        }
    }

    @Check
    public void checkEnumOrdinalOrDatabaseLength(Enum dslEnum) {
        String hint = dslEnum.getHint();
        if (hint != null && hint.contains("ordinal") && hint.contains("databaseLength")) {
            this.error("ordinal in combination with databaseLength is not allowed", (EStructuralFeature)TacticdslPackage.Literals.ENUM__ATTRIBUTES);
        }
    }

    @Check
    public void checkEnumDatabaseLength(Enum dslEnum) {
        String hint = dslEnum.getHint();
        if (hint != null && hint.contains("databaseLength")) {
            EList<EnumAttribute> _attributes = dslEnum.getAttributes();
            for (EnumAttribute attr : _attributes) {
                if (!attr.isKey() || attr.getType().equals("String")) continue;
                this.error("databaseLength is not allowed for enums not having a key of type String", (EStructuralFeature)TacticdslPackage.Literals.ENUM__ATTRIBUTES);
                return;
            }
        }
    }

    @Check
    public void checkGap(Service service) {
        if (service.isGapClass() && service.isNoGapClass()) {
            this.error("Unclear specification of gap", (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NO_GAP_CLASS);
        }
    }

    @Check
    public void checkGap(Repository repository) {
        if (repository.isGapClass() && repository.isNoGapClass()) {
            this.error("Unclear specification of gap", (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NO_GAP_CLASS);
        }
    }

    @Check
    public void checkGap(DomainObject domainObj) {
        if (domainObj.isGapClass() && domainObj.isNoGapClass()) {
            this.error("Unclear specification of gap", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__NO_GAP_CLASS);
        }
    }

    @Check
    public void checkGap(BasicType domainObj) {
        if (domainObj.isGapClass() && domainObj.isNoGapClass()) {
            this.error("Unclear specification of gap", (EStructuralFeature)TacticdslPackage.Literals.BASIC_TYPE__NO_GAP_CLASS);
        }
    }

    @Check
    public void checkDiscriminatorValue(Entity domainObj) {
        if (domainObj.getDiscriminatorValue() != null && domainObj.getExtends() == null) {
            this.error("discriminatorValue can only be used when you extend another Entity", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__DISCRIMINATOR_VALUE);
        }
    }

    @Check
    public void checkDiscriminatorValue(ValueObject domainObj) {
        if (domainObj.getDiscriminatorValue() != null && domainObj.getExtends() == null) {
            this.error("discriminatorValue can only be used when you extend another ValueObject", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__DISCRIMINATOR_VALUE);
        }
    }

    @Check
    public void checkRepositoryOnlyForAggregateRoot(DomainObject domainObj) {
        if (domainObj.getRepository() != null && !domainObj.isAggregateRoot()) {
            this.error("Only aggregate roots can have Repository", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__REPOSITORY);
        }
    }

    @Check
    public void checkBelongsToRefersToAggregateRoot(DomainObject domainObj) {
        if (domainObj.getBelongsTo() != null && !domainObj.getBelongsTo().isAggregateRoot()) {
            this.error("belongsTo should refer to the aggregate root DomainObject", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__BELONGS_TO);
        }
    }

    @Check
    public void checkAggregateRootOnlyForPersistentValueObject(ValueObject domainObj) {
        if (domainObj.isAggregateRoot() && domainObj.isNotPersistent()) {
            this.error("aggregateRoot is only applicable for persistent ValueObjects", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__AGGREGATE_ROOT);
        }
    }

    @Check
    public void checkLength(Attribute attr) {
        boolean _matches;
        boolean _not_1;
        boolean _not;
        boolean _tripleEquals;
        String _length = attr.getLength();
        boolean bl = _tripleEquals = _length == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isString = this.isString(attr);
        boolean bl2 = _not = !_isString;
        if (_not) {
            this.error("length is only relevant for strings", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__LENGTH);
        }
        boolean bl3 = _not_1 = !(_matches = this.DIGITS_PATTERN.matcher(attr.getLength()).matches());
        if (_not_1) {
            this.error("length value should be numeric, e.g. length = \"10\"", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__LENGTH);
        }
    }

    @Check
    public void checkNullable(Attribute attr) {
        if (attr.isNullable() && this.isPrimitive(attr)) {
            this.error("nullable is not relevant for primitive types", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NULLABLE);
        }
    }

    @Check
    public void checkCreditCardNumber(Attribute attr) {
        if (attr.isCreditCardNumber() && !this.isString(attr)) {
            this.error("creditCardNumber is only relevant for strings", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__CREDIT_CARD_NUMBER);
        }
    }

    @Check
    public void checkEmail(Attribute attr) {
        if (attr.isEmail() && !this.isString(attr)) {
            this.error("email is only relevant for strings", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__EMAIL);
        }
    }

    @Check
    public void checkNotEmpty(Attribute attr) {
        if (attr.isNotEmpty() && !this.isString(attr) && !this.isCollection(attr)) {
            this.error("notEmpty is only relevant for strings or collection types", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NOT_EMPTY);
        }
    }

    @Check
    public void checkNotEmpty(Reference ref) {
        if (ref.isNotEmpty() && !this.isCollection(ref)) {
            this.error("notEmpty is only relevant for collection types", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__NOT_EMPTY);
        }
    }

    @Check
    public void checkSize(Reference ref) {
        boolean _not;
        boolean _tripleEquals;
        String _size = ref.getSize();
        boolean bl = _tripleEquals = _size == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isCollection = this.isCollection(ref);
        boolean bl2 = _not = !_isCollection;
        if (_not) {
            this.error("size is only relevant for collection types", (EStructuralFeature)TacticdslPackage.Literals.ANY_PROPERTY__SIZE);
        }
    }

    @Check
    public void checkPast(Attribute attr) {
        if (attr.isPast() && !this.isTemporal(attr)) {
            this.error("past is only relevant for temporal types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__PAST);
        }
    }

    @Check
    public void checkFuture(Attribute attr) {
        if (attr.isFuture() && !this.isTemporal(attr)) {
            this.error("future is only relevant for temporal types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__FUTURE);
        }
    }

    @Check
    public void checkMin(Attribute attr) {
        boolean _not;
        boolean _tripleEquals;
        String _min = attr.getMin();
        boolean bl = _tripleEquals = _min == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isNumeric = this.isNumeric(attr);
        boolean bl2 = _not = !_isNumeric;
        if (_not) {
            this.error("min is only relevant for numeric types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__MIN);
        }
    }

    @Check
    public void checkMax(Attribute attr) {
        boolean _not;
        boolean _tripleEquals;
        String _max = attr.getMax();
        boolean bl = _tripleEquals = _max == null;
        if (_tripleEquals) {
            return;
        }
        boolean _isNumeric = this.isNumeric(attr);
        boolean bl2 = _not = !_isNumeric;
        if (_not) {
            this.error("max is only relevant for numeric types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__MAX);
        }
    }

    @Check
    public void checkRange(Attribute attr) {
        if (attr.getRange() != null && !this.isNumeric(attr)) {
            this.error("range is only relevant for numeric types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__RANGE);
        }
    }

    @Check
    public void checkDigits(Attribute attr) {
        if (attr.getDigits() != null && !this.isNumeric(attr)) {
            this.error("digits is only relevant for numeric types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__DIGITS);
        }
    }

    @Check
    public void checkAssertTrue(Attribute attr) {
        if (attr.isAssertTrue() && !this.isBoolean(attr)) {
            this.error("assertTrue is only relevant for boolean types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__ASSERT_TRUE);
        }
    }

    @Check
    public void checkAssertFalse(Attribute attr) {
        if (attr.isAssertFalse() && !this.isBoolean(attr)) {
            this.error("assertFalse is only relevant for boolean types", (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__ASSERT_FALSE);
        }
    }

    @Check
    public void checkScaffoldValueObject(ValueObject valueObj) {
        if (valueObj.isScaffold() && valueObj.isNotPersistent()) {
            this.error("Scaffold not useful for not-persistent ValueObject.", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__SCAFFOLD);
        }
    }

    @Check
    public void checkScaffoldEvent(Event event) {
        if (event.isScaffold() && !event.isPersistent()) {
            this.error("Scaffold not useful for not-persistent event.", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__SCAFFOLD, "org.sculptor.dsl.validation.issue.non_persistent_event", new String[]{TacticdslPackage.Literals.DOMAIN_OBJECT__SCAFFOLD.getName()});
        }
    }

    @Check
    public void checkRepositoryEvent(Event event) {
        if (event.getRepository() != null && !event.isPersistent()) {
            this.error("Repository not useful for not-persistent event.", (EStructuralFeature)TacticdslPackage.Literals.DOMAIN_OBJECT__REPOSITORY, "org.sculptor.dsl.validation.issue.non_persistent_event", new String[]{TacticdslPackage.Literals.DOMAIN_OBJECT__REPOSITORY.getName()});
        }
    }

    private boolean isString(Attribute attribute) {
        return "String".equals(attribute.getType()) && !this.isCollection(attribute);
    }

    private boolean isCollection(Attribute attribute) {
        return attribute.getCollectionType() != null && !Objects.equal((Object)((Object)attribute.getCollectionType()), (Object)((Object)CollectionType.NONE));
    }

    private boolean isCollection(Reference ref) {
        return ref.getCollectionType() != null && !Objects.equal((Object)((Object)ref.getCollectionType()), (Object)((Object)CollectionType.NONE));
    }

    private boolean isPrimitive(Attribute attribute) {
        return this.SUPPORTED_PRIMITIVE_TYPES.contains(attribute.getType()) && !this.isCollection(attribute);
    }

    private boolean isTemporal(Attribute attribute) {
        return this.SUPPORTED_TEMPORAL_TYPES.contains(attribute.getType()) && !this.isCollection(attribute);
    }

    private boolean isNumeric(Attribute attribute) {
        return this.SUPPORTED_NUMERIC_TYPES.contains(attribute.getType()) && !this.isCollection(attribute);
    }

    private boolean isBoolean(Attribute attribute) {
        return this.SUPPORTED_BOOLEAN_TYPES.contains(attribute.getType()) && !this.isCollection(attribute);
    }

    @Check
    public void checkRepositoryDuplicateName(Repository repository) {
        if (repository.getName() != null && IteratorExtensions.size((Iterator)IteratorExtensions.filter(TacticDslExtensions.eAllOfClass(EcoreUtil.getRootContainer((EObject)repository), Repository.class), it -> {
            String _name = it.getName();
            String _name_1 = repository.getName();
            return Objects.equal((Object)_name, (Object)_name_1);
        })) > 1) {
            String _name = repository.getName();
            String _plus = "Duplicate name.  There is already an existing Repository named '" + _name;
            String _plus_1 = _plus + "'.";
            this.error(_plus_1, (EStructuralFeature)TacticdslPackage.Literals.SERVICE_REPOSITORY_OPTION__NAME, repository.getName(), new String[0]);
        }
    }

    @Check
    public void checkMissingReferenceNotationWithNoCollection(Attribute attr) {
        if (attr.getType() != null && Objects.equal((Object)((Object)attr.getCollectionType()), (Object)((Object)CollectionType.NONE)) && !IterableExtensions.isEmpty(TacticDslExtensions.domainObjectsForAttributeType(attr))) {
            String _type = attr.getType();
            String _plus = "Use - " + _type;
            this.warning(_plus, (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__TYPE, attr.getType(), new String[0]);
        }
    }

    @Check
    public void checkMissingReferenceNotationWithCollection(Attribute attr) {
        if (attr.getType() != null && !Objects.equal((Object)((Object)attr.getCollectionType()), (Object)((Object)CollectionType.NONE)) && !IterableExtensions.isEmpty(TacticDslExtensions.domainObjectsForAttributeType(attr))) {
            CollectionType _collectionType = attr.getCollectionType();
            String _plus = "Use - " + (Object)((Object)_collectionType);
            String _plus_1 = _plus + "<";
            String _type = attr.getType();
            String _plus_2 = _plus_1 + _type;
            String _plus_3 = _plus_2 + ">";
            this.warning(_plus_3, (EStructuralFeature)TacticdslPackage.Literals.ATTRIBUTE__TYPE, attr.getType(), new String[0]);
        }
    }

    @Check
    public void checkMissingDomainObjectInServiceOperationReturnType(ServiceOperation it) {
        if (it.getReturnType() != null && it.getReturnType().getDomainObjectType() == null && it.getReturnType().getType() != null && TacticDslExtensions.firstDomainObjectForType(it.getReturnType()) != null) {
            String _type = it.getReturnType().getType();
            String _plus = "Use @" + _type;
            this.warning(_plus, (EStructuralFeature)TacticdslPackage.Literals.SERVICE_OPERATION__RETURN_TYPE, it.getReturnType().getType(), new String[0]);
        }
    }

    @Check
    public void checkMissingDomainObjectInRepositoryOperationReturnType(RepositoryOperation it) {
        if (it.getReturnType() != null && it.getReturnType().getDomainObjectType() == null && it.getReturnType().getType() != null && TacticDslExtensions.firstDomainObjectForType(it.getReturnType()) != null) {
            String _type = it.getReturnType().getType();
            String _plus = "Use @" + _type;
            this.warning(_plus, (EStructuralFeature)TacticdslPackage.Literals.REPOSITORY_OPERATION__RETURN_TYPE, it.getReturnType().getType(), new String[0]);
        }
    }

    @Check
    public void checkMissingDomainObjectInParameter(Parameter it) {
        if (it.getParameterType() != null && it.getParameterType().getDomainObjectType() == null && it.getParameterType().getType() != null && TacticDslExtensions.firstDomainObjectForType(it.getParameterType()) != null) {
            String _type = it.getParameterType().getType();
            String _plus = "Use @" + _type;
            this.warning(_plus, (EStructuralFeature)TacticdslPackage.Literals.PARAMETER__PARAMETER_TYPE, it.getParameterType().getType(), new String[0]);
        }
    }
}

