/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.model.criteria;

import ch.hsr.servicecutter.model.criteria.CouplingCriterion;
import ch.hsr.servicecutter.model.criteria.CouplingCriterionCharacteristic;
import ch.hsr.servicecutter.model.criteria.CouplingType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CouplingCriteriaCatalog {
    private Map<String, CouplingCriterion> couplingCriteriaCatalog = new HashMap<String, CouplingCriterion>();
    private List<CouplingCriterionCharacteristic> couplingCriteriaCharacteristics = new ArrayList<CouplingCriterionCharacteristic>();

    public CouplingCriteriaCatalog() {
        this.initializeCatalog();
    }

    public CouplingCriterion getCriterionByName(String name) {
        return this.couplingCriteriaCatalog.get(name);
    }

    public List<CouplingCriterionCharacteristic> getCouplingCriteriaCharacteristics4CriterionName(String criterionName) {
        return new ArrayList<CouplingCriterionCharacteristic>(this.couplingCriteriaCharacteristics.stream().filter(cc -> cc.getCouplingCriterion().getName().equals(criterionName)).collect(Collectors.toList()));
    }

    public CouplingCriterionCharacteristic getCouplingCriterionCharacteristicByNameAndCouplingCriterion(String name, CouplingCriterion couplingCriterion) {
        return this.couplingCriteriaCharacteristics.stream().filter(ccc -> ccc.getName().equals(name) && ccc.getCouplingCriterion().equals(couplingCriterion)).findFirst().get();
    }

    public CouplingCriterionCharacteristic getCouplingCriterionCharacteristicByCouplingCriterionAndIsDefault(CouplingCriterion couplingCriterion) {
        return this.couplingCriteriaCharacteristics.stream().filter(ccc -> ccc.getCouplingCriterion().equals(couplingCriterion) && ccc.isDefault()).findFirst().get();
    }

    private void initializeCatalog() {
        this.couplingCriteriaCatalog.put("Identity & Lifecycle Commonality", new CouplingCriterion("Identity & Lifecycle Commonality", "Nanoentities that belong to the same identity and therefore share a common lifecycle.", CouplingType.COHESIVENESS));
        this.couplingCriteriaCatalog.put("Semantic Proximity", new CouplingCriterion("Semantic Proximity", "Two nanoentities are semantically proximate when they have a semantic connection given by the business domain. The strongest indicator for semantic proximity is coherent access on nanoentities within the same use case.", CouplingType.COHESIVENESS));
        this.couplingCriteriaCatalog.put("Shared Owner", new CouplingCriterion("Shared Owner", "The same person, role or department is responsible for a group of nanoentities. Service decomposition should try to keep entities with the same responsible role together while not mixing entities with different responsible instances in one service.", CouplingType.COHESIVENESS));
        this.couplingCriteriaCatalog.put("Structural Volatility", new CouplingCriterion("Structural Volatility", "How often change requests need to be implemented affecting nanoentities.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Latency", new CouplingCriterion("Latency", "Groups of nanoentities with high performance requirements for a specific user request. These nanoentities should be modelled in the same service to avoid remote calls.", CouplingType.COHESIVENESS));
        this.couplingCriteriaCatalog.put("Consistency Criticality", new CouplingCriterion("Consistency Criticality", "Some data such as financial records loses its value in case of inconsistencies while other data is more tolerant to inconsistencies.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Availability Criticality", new CouplingCriterion("Availability Criticality", "Nanoentities have varying availability constraints. Some are critical while others can be unavailable for some time. As providing high availability comes at a cost, nanoentities classified with different characteristics should not be composed in the same service.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Content Volatility", new CouplingCriterion("Content Volatility", "A nanoentity can be classified by its volatility which defines how frequent it is updated. Highly volatile and more stable nanoentities should be composed in different services.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Consistency Constraint", new CouplingCriterion("Consistency Constraint", "A group of nanoentities that have a dependent state and therefore need to be kept consistent to each other.", CouplingType.CONSTRAINTS));
        this.couplingCriteriaCatalog.put("Storage Similarity", new CouplingCriterion("Storage Similarity", "Storage that is required to persist all instances of a nanoentity.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Predefined Service Constraint", new CouplingCriterion("Predefined Service Constraint", "There might be the following reasons why some nanoentities forcefully need to be modelled in the same service: Technological optimizations or Legacy systems", CouplingType.CONSTRAINTS));
        this.couplingCriteriaCatalog.put("Security Contextuality", new CouplingCriterion("Security Contextuality", "A security role is allowed to see or process a group of nanoentities. Mixing security contexts in one service complicates authentication and authorization implementations.", CouplingType.COHESIVENESS));
        this.couplingCriteriaCatalog.put("Security Criticality", new CouplingCriterion("Security Criticality", "Criticality of an nanoentity in case of data loss or a privacy violation. Represents the reputational or financial damage when the information is disclosed to unauthorized parties. As high security criticality comes at a cost, nanoentities classified with different characteristics should not be composed in the same service.", CouplingType.COMPATIBILITY));
        this.couplingCriteriaCatalog.put("Security Constraint", new CouplingCriterion("Security Constraint", "Groups of nanoentities are semantically related but must not reside in the same service in order to satisfy information security requirements. This restriction can be established by an external party such as a certification authority or an internal design team.", CouplingType.CONSTRAINTS));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Structural Volatility"), "Often", 10, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Structural Volatility"), "Normal", 4, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Structural Volatility"), "Rarely", 0, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Consistency Criticality"), "High", 10, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Consistency Criticality"), "Eventually", 4, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Consistency Criticality"), "Weak", 0, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Availability Criticality"), "Critical", 10, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Availability Criticality"), "Normal", 4, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Availability Criticality"), "Low", 0, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Content Volatility"), "Often", 10, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Content Volatility"), "Regularly", 5, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Content Volatility"), "Rarely", 0, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Storage Similarity"), "Tiny", 0, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Storage Similarity"), "Normal", 3, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Storage Similarity"), "Huge", 10, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Security Criticality"), "Critical", 10, false));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Security Criticality"), "Internal", 3, true));
        this.couplingCriteriaCharacteristics.add(new CouplingCriterionCharacteristic(this.couplingCriteriaCatalog.get("Security Criticality"), "Public", 0, false));
    }
}

