/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.solver;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.model.Service;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.model.solver.EntityPair;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.scorer.Score;
import ch.hsr.servicecutter.solver.AbstractSolver;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.nlpub.watset.graph.Clustering;

public abstract class AbstractWatsetSolver
extends AbstractSolver<String, DefaultWeightedEdge> {
    protected final Graph<String, DefaultWeightedEdge> graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);

    public AbstractWatsetSolver(ServiceCutterContext context, Map<EntityPair, Map<String, Score>> scores) {
        super(context, scores);
        this.buildNodes();
        this.buildEdges();
    }

    protected abstract Clustering<String> getAlgorithm();

    @Override
    protected void createNode(String name) {
        this.graph.addVertex((Object)name);
    }

    @Override
    protected String getNode(String name) {
        return name;
    }

    @Override
    protected void createEdgeAndSetWeight(Nanoentity first, Nanoentity second, double weight) {
        DefaultWeightedEdge edge = (DefaultWeightedEdge)this.graph.addEdge((Object)this.createNodeIdentifier(first), (Object)this.createNodeIdentifier(second));
        this.setWeight(edge, weight);
    }

    @Override
    protected void removeEdge(DefaultWeightedEdge edge) {
        this.graph.removeEdge((Object)edge);
    }

    @Override
    protected DefaultWeightedEdge getEdge(Nanoentity first, Nanoentity second) {
        return (DefaultWeightedEdge)this.graph.getEdge((Object)this.createNodeIdentifier(first), (Object)this.createNodeIdentifier(second));
    }

    @Override
    protected Iterable<DefaultWeightedEdge> getEdges() {
        return this.graph.edgeSet();
    }

    @Override
    protected double getWeight(DefaultWeightedEdge edge) {
        return this.graph.getEdgeWeight((Object)edge);
    }

    @Override
    protected void setWeight(DefaultWeightedEdge edge, double weight) {
        this.graph.setEdgeWeight((Object)edge, weight);
    }

    @Override
    public SolverResult solve() {
        Clustering<String> alg = this.getAlgorithm();
        alg.fit();
        Collection clusterSet = alg.getClusters();
        HashSet<Service> services = new HashSet<Service>();
        char id = 'A';
        for (Collection cluster : clusterSet) {
            Service service = new Service();
            service.setId(id);
            service.setNanoentities(Lists.newLinkedList((Iterable)cluster));
            services.add(service);
            id = this.generateNextServiceId(id);
        }
        SolverResult result = new SolverResult();
        result.setServices(services);
        return result;
    }
}

