/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.parser.Status;
import org.crsh.cli.impl.tokenizer.Tokenizer;

public final class Parser<T>
implements Iterator<Event> {
    private final Tokenizer tokenizer;
    private final String mainName;
    private final Mode mode;
    private CommandDescriptor<T> command;
    private Status status;
    private final LinkedList<Event> next;

    public Parser(Tokenizer tokenizer, CommandDescriptor<T> command, String mainName, Mode mode) {
        this.tokenizer = tokenizer;
        this.command = command;
        this.mainName = mainName;
        this.status = new Status.ReadingOption();
        this.mode = mode;
        this.next = new LinkedList();
    }

    Status getStatus() {
        return this.status;
    }

    @Override
    public boolean hasNext() {
        if (this.next.isEmpty()) {
            this.determine();
        }
        return this.next.size() > 0;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next.removeFirst();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void determine() {
        while (this.next.isEmpty()) {
            Status.Response<T> nextStatus = this.status.process(new Status.Request<T>(this.mode, this.mainName, this.tokenizer, this.command));
            if (nextStatus.status != null) {
                this.status = nextStatus.status;
            }
            if (nextStatus.events != null) {
                this.next.addAll(nextStatus.events);
            }
            if (nextStatus.command == null) continue;
            this.command = nextStatus.command;
        }
    }
}

