/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.crsh.cli.completers.EmptyCompleter;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.SyntaxException;
import org.crsh.cli.impl.descriptor.IllegalParameterException;
import org.crsh.cli.impl.descriptor.IllegalValueTypeException;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.type.ValueType;

public abstract class ParameterDescriptor {
    private final Description description;
    private final ParameterType<?> type;
    private final boolean required;
    private final boolean password;
    private final Class<? extends Completer> completerType;
    private final Annotation annotation;
    private final boolean unquote;

    public ParameterDescriptor(ParameterType<?> type, Description description, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        if (completerType == EmptyCompleter.class) {
            completerType = type.getValueType().getCompleter();
        }
        this.description = description;
        this.required = required;
        this.password = password;
        this.completerType = completerType;
        this.annotation = annotation;
        this.unquote = unquote;
        this.type = type;
    }

    public Object parse(String s) throws Exception {
        return this.type.parse(s);
    }

    public abstract Object parse(List<String> var1) throws SyntaxException;

    public Class<?> getDeclaredType() {
        return this.type.getDeclaredType();
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }

    public Description getDescription() {
        return this.description;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public boolean isUnquote() {
        return this.unquote;
    }

    public final boolean isPassword() {
        return this.password;
    }

    public final ValueType getType() {
        return this.type.getValueType();
    }

    public final Multiplicity getMultiplicity() {
        return this.type.getMultiplicity();
    }

    public final boolean isSingleValued() {
        return this.getMultiplicity() == Multiplicity.SINGLE;
    }

    public final boolean isMultiValued() {
        return this.getMultiplicity() == Multiplicity.MULTI;
    }

    public final Class<? extends Completer> getCompleterType() {
        return this.completerType;
    }

    public abstract void printUsage(Appendable var1) throws IOException;
}

