/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;

public class SSHContext {
    static final Pattern LC_TYPE_PATTERN = Pattern.compile("(?:\\p{Alpha}{2}_\\p{Alpha}{2}\\.)?([^@]+)(?:@.+)?");
    private static final Logger log = Logger.getLogger(SSHContext.class.getName());
    public final int verase;
    private final Environment env;
    public final Charset encoding;

    public static Charset parseEncoding(String value) {
        Matcher matcher = LC_TYPE_PATTERN.matcher(value);
        if (matcher.matches()) {
            String encoding = matcher.group(1);
            try {
                return Charset.forName(encoding);
            }
            catch (Exception e) {
                log.log(Level.FINE, "Could not find charset " + encoding + " for LC_TYPE " + value, e);
                return null;
            }
        }
        log.log(Level.FINE, "Could not parse LC_TYPE " + value);
        return null;
    }

    public SSHContext(Environment env) {
        if (env == null) {
            throw new NullPointerException("No null env");
        }
        Integer verase = (Integer)env.getPtyModes().get(PtyMode.VERASE);
        String LC_CTYPE = (String)env.getEnv().get("LC_CTYPE");
        Charset encoding = LC_CTYPE != null ? SSHContext.parseEncoding(LC_CTYPE) : null;
        this.env = env;
        this.verase = verase != null ? verase : -1;
        this.encoding = encoding;
    }

    public int getWidth() {
        String s = (String)this.env.getEnv().get("COLUMNS");
        int width = -1;
        if (s != null) {
            try {
                width = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Could not parse ssh term width " + s);
            }
        }
        return width;
    }

    public int getHeight() {
        String s = (String)this.env.getEnv().get("LINES");
        int height = -1;
        if (s != null) {
            try {
                height = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.log(Level.WARNING, "Could not parse ssh term height " + s);
            }
        }
        return height;
    }

    public String getProperty(String key) {
        return (String)this.env.getEnv().get(key);
    }
}

