/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cron;

import it.sauronsoftware.cron4j.SchedulingPattern;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cron.CRaSHTask;
import org.crsh.cron.CronPlugin;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.text.Chunk;
import org.crsh.text.Text;

public class CRaSHTaskProcess {
    private static final Logger log = Logger.getLogger(CronPlugin.class.getName());
    private final CRaSHTask task;
    private final StringBuilder msg = new StringBuilder();
    private final long time;
    private volatile boolean active;
    private final ShellProcessContext context = new ShellProcessContext(){

        public void end(ShellResponse response) {
            CRaSHTaskProcess.this.active = false;
            ((CRaSHTaskProcess)CRaSHTaskProcess.this).task.plugin.processes.remove(CRaSHTaskProcess.this);
            log.log(Level.FINE, "Terminated task with id=" + ((CRaSHTaskProcess)CRaSHTaskProcess.this).task.def.hashCode() + " pattern=" + ((CRaSHTaskProcess)CRaSHTaskProcess.this).task.def.getSchedullingPattern() + " : " + ((CRaSHTaskProcess)CRaSHTaskProcess.this).task.def.getLine());
            log.log(Level.FINEST, CRaSHTaskProcess.this.msg.toString());
        }

        public boolean takeAlternateBuffer() throws IOException {
            return false;
        }

        public boolean releaseAlternateBuffer() throws IOException {
            return false;
        }

        public String getProperty(String propertyName) {
            return null;
        }

        public String readLine(String msg, boolean echo) {
            return null;
        }

        public int getWidth() {
            return 120;
        }

        public int getHeight() {
            return 40;
        }

        public void write(Chunk element) throws IOException {
            if (element instanceof Text) {
                CRaSHTaskProcess.this.msg.append(((Text)element).getText().toString());
            }
        }

        public void flush() throws IOException {
        }
    };

    CRaSHTaskProcess(CRaSHTask task) {
        this.task = task;
        this.time = System.currentTimeMillis();
        this.msg.append("Terminated task ").append(task.def.getLine()).append(" started at ").append(new Date(this.time)).append(" with buffer ");
    }

    public boolean isActive() {
        return this.active;
    }

    public long getTime() {
        return this.time;
    }

    public SchedulingPattern getSchedulingPattern() {
        return this.task.def.getSchedullingPattern();
    }

    public String getLine() {
        return this.task.def.getLine();
    }

    void run() {
        Shell sh = this.task.factory.create(null);
        ShellProcess sp = sh.createProcess(this.task.def.getLine());
        this.task.plugin.processes.add(this);
        this.task.plugin.history.add(this);
        while (this.task.plugin.history.size() > 100) {
            this.task.plugin.history.remove();
        }
        this.active = true;
        log.log(Level.FINE, "Started task with id=" + this.task.def.hashCode() + " pattern=" + this.task.def.getSchedullingPattern() + " : " + this.task.def.getLine());
        sp.execute(this.context);
    }
}

