/*
 * Decompiled with CFR 0.152.
 */
package org.curioswitch.common.protobuf.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SerializedString;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.curioswitch.common.protobuf.json.TypeSpecificMarshaller;

public final class SerializeSupport {
    private static final Comparator<Map.Entry<String, ?>> STRING_KEY_COMPARATOR = (o1, o2) -> {
        ByteString s1 = ByteString.copyFromUtf8((String)((String)o1.getKey()));
        ByteString s2 = ByteString.copyFromUtf8((String)((String)o2.getKey()));
        return ByteString.unsignedLexicographicalComparator().compare(s1, s2);
    };

    public static void printRepeatedSignedInt32(List<Integer> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printSignedInt32(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printSignedInt32(int value, JsonGenerator gen) throws IOException {
        gen.writeNumber(value);
    }

    public static void printRepeatedSignedInt64(List<Long> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printSignedInt64(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printSignedInt64(long value, JsonGenerator gen) throws IOException {
        gen.writeString(Long.toString(value));
    }

    public static void printRepeatedUnsignedInt32(List<Integer> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printUnsignedInt32(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printUnsignedInt32(int value, JsonGenerator gen) throws IOException {
        gen.writeNumber(SerializeSupport.normalizeUnsignedInt32(value));
    }

    public static long normalizeUnsignedInt32(int value) {
        return value >= 0 ? (long)value : (long)value & 0xFFFFFFFFL;
    }

    public static void printRepeatedUnsignedInt64(List<Long> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printUnsignedInt64(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printUnsignedInt64(long value, JsonGenerator gen) throws IOException {
        gen.writeString(SerializeSupport.normalizeUnsignedInt64(value));
    }

    public static String normalizeUnsignedInt64(long value) {
        return value >= 0L ? Long.toString(value) : BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void printRepeatedBool(List<Boolean> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printBool(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printBool(boolean value, JsonGenerator gen) throws IOException {
        gen.writeBoolean(value);
    }

    public static void printRepeatedFloat(List<Float> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printFloat(values.get(i).floatValue(), gen);
        }
        gen.writeEndArray();
    }

    public static void printFloat(float value, JsonGenerator gen) throws IOException {
        gen.writeNumber(value);
    }

    public static void printRepeatedDouble(List<Double> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printDouble(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printDouble(double value, JsonGenerator gen) throws IOException {
        gen.writeNumber(value);
    }

    public static void printRepeatedString(List<String> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printString(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printString(String value, JsonGenerator gen) throws IOException {
        gen.writeString(value);
    }

    public static void printRepeatedBytes(List<ByteString> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printBytes(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printBytes(ByteString value, JsonGenerator gen) throws IOException {
        gen.writeBinary(value.toByteArray());
    }

    public static void printRepeatedNull(List<Integer> values, JsonGenerator gen) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printNull(values.get(i), gen);
        }
        gen.writeEndArray();
    }

    public static void printNull(int unused, JsonGenerator gen) throws IOException {
        gen.writeNull();
    }

    public static void printRepeatedEnum(List<Integer> values, JsonGenerator gen, Descriptors.EnumDescriptor descriptor) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printEnum(values.get(i), gen, descriptor);
        }
        gen.writeEndArray();
    }

    public static void printEnum(int value, JsonGenerator gen, Descriptors.EnumDescriptor descriptor) throws IOException {
        Descriptors.EnumValueDescriptor valueDescriptor = descriptor.findValueByNumber(value);
        if (valueDescriptor == null) {
            gen.writeNumber(value);
        } else {
            gen.writeString(valueDescriptor.getName());
        }
    }

    public static void printEnum(Descriptors.EnumValueDescriptor value, JsonGenerator gen) throws IOException {
        if (value.getIndex() == -1) {
            gen.writeString(Integer.toString(value.getNumber()));
        } else {
            gen.writeString(value.getName());
        }
    }

    public static <T extends Message> void printRepeatedMessage(List<T> values, JsonGenerator gen, TypeSpecificMarshaller<T> serializer) throws IOException {
        int numElements = values.size();
        gen.writeStartArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            SerializeSupport.printMessage((Message)values.get(i), gen, serializer);
        }
        gen.writeEndArray();
    }

    public static <T extends Message> void printMessage(T value, JsonGenerator gen, TypeSpecificMarshaller<T> serializer) throws IOException {
        serializer.writeValue(value, gen);
    }

    public static SerializedString serializeString(String name) {
        SerializedString s = new SerializedString(name);
        s.asQuotedChars();
        s.asQuotedUTF8();
        s.asUnquotedUTF8();
        return s;
    }

    public static Iterator<? extends Map.Entry> mapIterator(Map<?, ?> map, boolean sortingMapKeys, boolean stringKey) {
        if (!sortingMapKeys) {
            return map.entrySet().iterator();
        }
        Comparator<Map.Entry<String, Object>> cmp = stringKey ? STRING_KEY_COMPARATOR : Map.Entry.comparingByKey();
        ArrayList sorted = new ArrayList(map.entrySet());
        sorted.sort(cmp);
        return sorted.iterator();
    }

    private SerializeSupport() {
    }
}

