/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;

public class BomParserFactory {
    private BomParserFactory() {
    }

    public static Parser createParser(File file) throws ParseException {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)new FileInputStream(file), (int)1);
            if (bytes[0] == 123) {
                return new JsonParser();
            }
            if (bytes[0] == 60) {
                return new XmlParser();
            }
            throw new ParseException("The specified BOM is not in a supported format. Supported formats are XML and JSON");
        }
        catch (IOException e) {
            throw new ParseException("An error occurred creating parser from file", e);
        }
    }
}

