/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xml.sax.SAXException;

public abstract class CycloneDxSchema {
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_12 = "http://cyclonedx.org/schema/bom/1.2";
    public static final String NS_DEPENDENCY_GRAPH_10 = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.2";
    public static final Version VERSION_LATEST = Version.VERSION_12;

    public org.everit.json.schema.Schema getJsonSchema(Version schemaVersion, boolean strict) throws IOException {
        return this.getJsonSchema12(strict);
    }

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        if (Version.VERSION_11 == schemaVersion) {
            return this.getXmlSchema11();
        }
        return this.getXmlSchema12();
    }

    private Schema getXmlSchema10() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"));
    }

    private Schema getXmlSchema11() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"));
    }

    private Schema getXmlSchema12() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.2.xsd"));
    }

    public Schema getXmlSchema(InputStream ... inputStreams) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            schemaFiles[i] = new StreamSource(inputStreams[i]);
        }
        return schemaFactory.newSchema(schemaFiles);
    }

    private org.everit.json.schema.Schema getJsonSchema12(boolean strict) throws IOException {
        if (strict) {
            return this.getJsonSchema(this.getClass().getClassLoader().getResourceAsStream("bom-1.2-strict.schema.json"));
        }
        return this.getJsonSchema(this.getClass().getClassLoader().getResourceAsStream("bom-1.2.schema.json"));
    }

    private org.everit.json.schema.Schema getJsonSchema(InputStream inputStream) throws IOException {
        JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
        return SchemaLoader.load((JSONObject)rawSchema);
    }

    public static enum Version {
        VERSION_10("http://cyclonedx.org/schema/bom/1.0", "1.0", 1.0),
        VERSION_11("http://cyclonedx.org/schema/bom/1.1", "1.1", 1.1),
        VERSION_12("http://cyclonedx.org/schema/bom/1.2", "1.2", 1.2);

        private String namespace;
        private String versionString;
        private double version;

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public double getVersion() {
            return this.version;
        }

        private Version(String namespace, String versionString, double version) {
            this.namespace = namespace;
            this.versionString = versionString;
            this.version = version;
        }
    }
}

