/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.cyclonedx.model.AttachmentText;

public class AttachmentTextConverter
implements Converter {
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        AttachmentText attachmentText = (AttachmentText)object;
        writer.addAttribute("content-type", attachmentText.getContentType());
        writer.addAttribute("encoding", attachmentText.getEncoding());
        writer.setValue(attachmentText.getText());
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(AttachmentText.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String contentType = reader.getAttribute("content-type");
        String encoding = reader.getAttribute("encoding");
        String text = reader.getValue();
        AttachmentText attachmentText = new AttachmentText();
        attachmentText.setContentType(contentType);
        attachmentText.setEncoding(encoding);
        attachmentText.setText(text);
        return attachmentText;
    }
}

