/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.converters;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.cyclonedx.model.Hash;

public class HashConverter
implements Converter {
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Hash hash = (Hash)object;
        writer.addAttribute("alg", hash.getAlgorithm());
        writer.setValue(hash.getValue());
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(Hash.class);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String alg = reader.getAttribute("alg");
        String value = reader.getValue();
        return new Hash(alg, value);
    }
}

