/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.json;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.generators.json.OrderedJSONObjectFactory;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.Commit;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.IdentifiableActionType;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Swid;
import org.cyclonedx.model.Tool;
import org.json.JSONArray;
import org.json.JSONObject;

abstract class AbstractBomJsonGenerator
extends CycloneDxSchema
implements BomJsonGenerator {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    JSONObject doc = OrderedJSONObjectFactory.create();

    AbstractBomJsonGenerator() {
    }

    void createMetadataNode(JSONObject doc, Metadata metadata) {
        if (metadata != null) {
            JSONObject mdo = OrderedJSONObjectFactory.create();
            if (metadata.getTimestamp() != null) {
                mdo.put("timestamp", (Object)this.dateFormat.format(metadata.getTimestamp()));
            } else {
                mdo.put("timestamp", (Object)this.dateFormat.format(new Date()));
            }
            if (metadata.getTools() != null && metadata.getTools().size() > 0) {
                JSONArray jsonTools = new JSONArray();
                for (Tool tool : metadata.getTools()) {
                    JSONObject jsonTool = OrderedJSONObjectFactory.create();
                    jsonTool.put("vendor", (Object)AbstractBomJsonGenerator.stripBreaks(tool.getVendor()));
                    jsonTool.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(tool.getName()));
                    jsonTool.put("version", (Object)AbstractBomJsonGenerator.stripBreaks(tool.getVersion()));
                    this.createHashesNode(jsonTool, tool.getHashes());
                    jsonTools.put((Object)jsonTool);
                }
                mdo.put("tools", (Object)jsonTools);
            }
            if (metadata.getAuthors() != null && metadata.getAuthors().size() > 0) {
                JSONArray jsonAuthors = new JSONArray();
                for (OrganizationalContact author : metadata.getAuthors()) {
                    jsonAuthors.put((Object)this.createOrganizationalContactNode(author));
                }
                mdo.put("authors", (Object)jsonAuthors);
            }
            if (metadata.getComponent() != null) {
                mdo.put("component", (Object)this.createComponentNode(metadata.getComponent()));
            }
            mdo.put("manufacture", (Object)this.createOrganizationalEntityNode(metadata.getManufacture()));
            mdo.put("supplier", (Object)this.createOrganizationalEntityNode(metadata.getSupplier()));
            doc.put("metadata", (Object)mdo);
        }
    }

    void createComponentsNode(JSONObject json, List<Component> components, String nodeName) {
        if (components != null && !components.isEmpty()) {
            JSONArray jsonComponents = new JSONArray();
            for (Component component : components) {
                jsonComponents.put((Object)this.createComponentNode(component));
            }
            json.put(nodeName, (Object)jsonComponents);
        }
    }

    JSONObject createComponentNode(Component component) {
        JSONObject json = OrderedJSONObjectFactory.create();
        json.put("type", (Object)component.getType().getTypeName());
        json.put("bom-ref", (Object)AbstractBomJsonGenerator.stripBreaks(component.getBomRef()));
        json.put("mime-type", (Object)AbstractBomJsonGenerator.stripBreaks(component.getMimeType()));
        json.put("supplier", (Object)this.createOrganizationalEntityNode(component.getSupplier()));
        json.put("author", (Object)AbstractBomJsonGenerator.stripBreaks(component.getAuthor()));
        json.put("publisher", (Object)AbstractBomJsonGenerator.stripBreaks(component.getPublisher()));
        json.put("group", (Object)AbstractBomJsonGenerator.stripBreaks(component.getGroup()));
        json.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(component.getName()));
        json.put("version", (Object)AbstractBomJsonGenerator.stripBreaks(component.getVersion()));
        json.put("description", (Object)AbstractBomJsonGenerator.stripBreaks(component.getDescription()));
        if (component.getScope() != null) {
            json.put("scope", (Object)component.getScope().getScopeName());
        }
        this.createHashesNode(json, component.getHashes());
        this.createLicenseNode(json, component.getLicenseChoice());
        json.put("copyright", (Object)AbstractBomJsonGenerator.stripBreaks(component.getCopyright()));
        json.put("cpe", (Object)AbstractBomJsonGenerator.stripBreaks(component.getCpe()));
        json.put("purl", (Object)AbstractBomJsonGenerator.stripBreaks(component.getPurl()));
        this.createSwidNode(json, component.getSwid());
        if (this.getSchemaVersion().getVersion() == 1.0 || component.isModified()) {
            json.put("modified", component.isModified());
        }
        this.createPedigreeNode(json, component.getPedigree());
        this.createExternalReferencesNode(json, component.getExternalReferences());
        this.createComponentsNode(json, component.getComponents(), "components");
        return json;
    }

    private void createHashesNode(JSONObject parent, List<Hash> hashes) {
        if (hashes != null && !hashes.isEmpty()) {
            JSONArray jsonHashes = new JSONArray();
            for (Hash hash : hashes) {
                JSONObject jsonHash = OrderedJSONObjectFactory.create();
                jsonHash.put("alg", (Object)hash.getAlgorithm());
                jsonHash.put("content", (Object)hash.getValue());
                jsonHashes.put((Object)jsonHash);
            }
            parent.put("hashes", (Object)jsonHashes);
        }
    }

    private void createLicenseNode(JSONObject parent, LicenseChoice licenseChoice) {
        if (licenseChoice != null) {
            JSONArray jsonLicenses = new JSONArray();
            if (licenseChoice.getLicenses() != null && !licenseChoice.getLicenses().isEmpty()) {
                for (License license : licenseChoice.getLicenses()) {
                    JSONObject wrapper = new JSONObject();
                    JSONObject jsonLicense = OrderedJSONObjectFactory.create();
                    if (license.getId() != null) {
                        jsonLicense.put("id", (Object)license.getId());
                    } else if (license.getName() != null) {
                        jsonLicense.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(license.getName()));
                    }
                    if (license.getAttachmentText() != null && license.getAttachmentText().getText() != null) {
                        this.createAttachmentTextNode(jsonLicense, license.getAttachmentText());
                    }
                    jsonLicense.put("url", (Object)AbstractBomJsonGenerator.stripBreaks(license.getUrl()));
                    wrapper.put("license", (Object)jsonLicense);
                    jsonLicenses.put((Object)wrapper);
                }
            } else if (licenseChoice.getExpression() != null) {
                JSONObject jsonLicense = OrderedJSONObjectFactory.create();
                jsonLicense.put("expression", (Object)AbstractBomJsonGenerator.stripBreaks(licenseChoice.getExpression()));
                jsonLicenses.put((Object)jsonLicense);
            }
            parent.put("licenses", (Object)jsonLicenses);
        }
    }

    private void createSwidNode(JSONObject jsonComponent, Swid swid) {
        if (swid != null) {
            JSONObject jsonSwid = OrderedJSONObjectFactory.create();
            jsonSwid.put("tagId", (Object)AbstractBomJsonGenerator.stripBreaks(swid.getTagId()));
            jsonSwid.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(swid.getName()));
            jsonSwid.put("version", (Object)AbstractBomJsonGenerator.stripBreaks(swid.getVersion()));
            jsonSwid.put("tagVersion", swid.getTagVersion());
            jsonSwid.put("patch", swid.isPatch());
            this.createAttachmentTextNode(jsonSwid, swid.getAttachmentText());
            jsonComponent.put("swid", (Object)jsonSwid);
        }
    }

    private void createAttachmentTextNode(JSONObject json, AttachmentText attachment) {
        if (attachment != null && attachment.getText() != null) {
            JSONObject jsonAttachment = OrderedJSONObjectFactory.create();
            jsonAttachment.put("contentType", (Object)AbstractBomJsonGenerator.stripBreaks(attachment.getContentType()));
            jsonAttachment.put("encoding", (Object)AbstractBomJsonGenerator.stripBreaks(attachment.getEncoding()));
            jsonAttachment.put("content", (Object)attachment.getText());
            json.put("text", (Object)jsonAttachment);
        }
    }

    void createExternalReferencesNode(JSONObject parent, List<ExternalReference> references) {
        if (references != null && !references.isEmpty()) {
            JSONArray jsonReferences = new JSONArray();
            for (ExternalReference reference : references) {
                JSONObject jsonReference = OrderedJSONObjectFactory.create();
                jsonReference.put("type", (Object)reference.getType().getTypeName());
                jsonReference.put("url", (Object)AbstractBomJsonGenerator.stripBreaks(reference.getUrl()));
                jsonReference.put("comment", (Object)AbstractBomJsonGenerator.stripBreaks(reference.getComment()));
                jsonReferences.put((Object)jsonReference);
            }
            parent.put("externalReferences", (Object)jsonReferences);
        }
    }

    private void createPedigreeNode(JSONObject parent, Pedigree pedigree) {
        if (pedigree != null) {
            JSONObject jsonPedigree = OrderedJSONObjectFactory.create();
            if (pedigree.getAncestors() != null && !pedigree.getAncestors().isEmpty()) {
                this.createComponentsNode(jsonPedigree, pedigree.getAncestors(), "ancestors");
            }
            if (pedigree.getDescendants() != null && !pedigree.getDescendants().isEmpty()) {
                this.createComponentsNode(jsonPedigree, pedigree.getDescendants(), "descendants");
            }
            if (pedigree.getVariants() != null && !pedigree.getVariants().isEmpty()) {
                this.createComponentsNode(jsonPedigree, pedigree.getVariants(), "variants");
            }
            if (pedigree.getCommits() != null && !pedigree.getCommits().isEmpty()) {
                this.createCommitsNode(jsonPedigree, pedigree.getCommits());
            }
            jsonPedigree.put("notes", (Object)AbstractBomJsonGenerator.stripBreaks(pedigree.getNotes()));
            parent.put("pedigree", (Object)jsonPedigree);
        }
    }

    private void createCommitsNode(JSONObject parent, List<Commit> commits) {
        if (commits != null && !commits.isEmpty()) {
            JSONArray jsonCommits = new JSONArray();
            for (Commit commit : commits) {
                JSONObject jsonCommit = OrderedJSONObjectFactory.create();
                jsonCommit.put("uid", (Object)AbstractBomJsonGenerator.stripBreaks(commit.getUid()));
                jsonCommit.put("url", (Object)AbstractBomJsonGenerator.stripBreaks(commit.getUrl()));
                this.createActorNode(jsonCommit, "author", commit.getAuthor());
                this.createActorNode(jsonCommit, "committer", commit.getCommitter());
                jsonCommit.put("message", (Object)AbstractBomJsonGenerator.stripBreaks(commit.getMessage()));
                jsonCommits.put((Object)jsonCommit);
            }
            parent.put("commits", (Object)jsonCommits);
        }
    }

    private void createActorNode(JSONObject parent, String nodeName, IdentifiableActionType actor) {
        if (actor != null) {
            JSONObject json = OrderedJSONObjectFactory.create();
            json.put("timestamp", (Object)this.dateFormat.format(actor.getTimestamp()));
            json.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(actor.getName()));
            json.put("email", (Object)AbstractBomJsonGenerator.stripBreaks(actor.getEmail()));
            parent.put(nodeName, (Object)json);
        }
    }

    private JSONObject createOrganizationalContactNode(OrganizationalContact contact) {
        if (contact != null) {
            JSONObject jsonContact = OrderedJSONObjectFactory.create();
            jsonContact.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(contact.getName()));
            jsonContact.put("email", (Object)AbstractBomJsonGenerator.stripBreaks(contact.getEmail()));
            jsonContact.put("phone", (Object)AbstractBomJsonGenerator.stripBreaks(contact.getPhone()));
            return jsonContact;
        }
        return null;
    }

    private JSONArray createOrganizationalContactsNode(List<OrganizationalContact> contacts) {
        if (contacts != null) {
            JSONArray array = new JSONArray();
            for (OrganizationalContact contact : contacts) {
                array.put((Object)this.createOrganizationalContactNode(contact));
            }
            return array;
        }
        return null;
    }

    private JSONObject createOrganizationalEntityNode(OrganizationalEntity entity) {
        if (entity != null) {
            JSONObject jsonEntity = OrderedJSONObjectFactory.create();
            jsonEntity.put("name", (Object)AbstractBomJsonGenerator.stripBreaks(entity.getName()));
            jsonEntity.put("url", Collections.singletonList(AbstractBomJsonGenerator.stripBreaks(entity.getUrl())));
            jsonEntity.put("contact", (Object)this.createOrganizationalContactsNode(entity.getContacts()));
            return jsonEntity;
        }
        return null;
    }

    void createDependenciesNode(JSONObject parent, List<Dependency> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            JSONArray jsonDependencies = new JSONArray();
            for (Dependency dependency : dependencies) {
                JSONObject dependencyNode = OrderedJSONObjectFactory.create();
                dependencyNode.put("ref", (Object)dependency.getRef());
                if (dependency.getDependencies() != null && !dependency.getDependencies().isEmpty()) {
                    JSONArray jsonDependsOn = new JSONArray();
                    for (Dependency dependsOn : dependency.getDependencies()) {
                        jsonDependsOn.put((Object)dependsOn.getRef());
                    }
                    dependencyNode.put("dependsOn", (Object)jsonDependsOn);
                }
                jsonDependencies.put((Object)dependencyNode);
            }
            parent.put("dependencies", (Object)jsonDependencies);
        }
    }

    static String stripBreaks(String in) {
        if (in == null) {
            return null;
        }
        return in.trim().replace("\r\n", " ").replace("\n", " ").replace("\t", " ").replace("\r", " ").replaceAll(" +", " ");
    }

    @Override
    public String toJsonString() {
        return this.doc.toString(2);
    }

    @Override
    public String toString() {
        return this.doc.toString(0);
    }
}

