/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.xml;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.Commit;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExtensibleType;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.IdentifiableActionType;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Swid;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.BomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class AbstractBomXmlGenerator
extends CycloneDxSchema
implements BomXmlGenerator {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    Document doc;

    AbstractBomXmlGenerator() {
    }

    public DocumentBuilder buildSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder();
    }

    Element createElement(Node parent, String name) {
        Element node = this.doc.createElement(name);
        parent.appendChild(node);
        return node;
    }

    Element createElementNS(Node parent, String namespace, String name) {
        Element node = this.doc.createElementNS(namespace, name);
        parent.appendChild(node);
        return node;
    }

    Element createElement(Node parent, String name, Object value) {
        return this.createElement(parent, name, value, new Attribute[0]);
    }

    Element createElement(Node parent, String name, Object value, boolean insideCDATA) {
        return this.createElement(parent, name, value, insideCDATA, new Attribute[0]);
    }

    Element createElement(Node parent, String name, Object value, Attribute ... attributes) {
        return this.createElement(parent, name, value, false, attributes);
    }

    Element createElement(Node parent, String name, Object value, boolean insideCDATA, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = name.contains(":") ? this.doc.createElement(name) : this.doc.createElementNS(this.getSchemaVersion().getNamespace(), name);
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                if (insideCDATA) {
                    node.appendChild(this.doc.createCDATASection(value.toString()));
                } else {
                    node.appendChild(this.doc.createTextNode(value.toString()));
                }
            }
            parent.appendChild(node);
        }
        return node;
    }

    void createComponentsNode(Node parent, List<Component> components) {
        if (components != null && !components.isEmpty()) {
            for (Component component : components) {
                this.createComponentNode(parent, component);
            }
        }
    }

    private void createComponentNode(Node parent, Component component) {
        ArrayList<Attribute> componentAttrs = new ArrayList<Attribute>();
        componentAttrs.add(new Attribute("type", component.getType().getTypeName()));
        if (component.getBomRef() != null) {
            componentAttrs.add(new Attribute("bom-ref", component.getBomRef()));
        }
        if (component.getMimeType() != null && this.getSchemaVersion().getVersion() >= 1.2) {
            componentAttrs.add(new Attribute("mime-type", component.getMimeType()));
        }
        Element componentNode = this.createElement(parent, "component", null, componentAttrs.toArray(new Attribute[0]));
        if (this.getSchemaVersion().getVersion() >= 1.2) {
            this.createOrganizationalEntityNode(componentNode, component.getSupplier(), "supplier");
            this.createElement(componentNode, "author", AbstractBomXmlGenerator.stripBreaks(component.getAuthor()));
        }
        this.createElement(componentNode, "publisher", AbstractBomXmlGenerator.stripBreaks(component.getPublisher()));
        this.createElement(componentNode, "group", AbstractBomXmlGenerator.stripBreaks(component.getGroup()));
        this.createElement(componentNode, "name", AbstractBomXmlGenerator.stripBreaks(component.getName()));
        this.createElement(componentNode, "version", AbstractBomXmlGenerator.stripBreaks(component.getVersion()));
        this.createElement((Node)componentNode, "description", (Object)AbstractBomXmlGenerator.stripBreaks(component.getDescription()), true);
        if (component.getScope() == null) {
            this.createElement(componentNode, "scope", Component.Scope.REQUIRED.getScopeName());
        } else {
            this.createElement(componentNode, "scope", component.getScope().getScopeName());
        }
        this.createHashesNode(componentNode, component.getHashes());
        this.createLicenseNode(componentNode, component.getLicenseChoice());
        this.createElement(componentNode, "copyright", AbstractBomXmlGenerator.stripBreaks(component.getCopyright()));
        this.createElement(componentNode, "cpe", AbstractBomXmlGenerator.stripBreaks(component.getCpe()));
        this.createElement(componentNode, "purl", AbstractBomXmlGenerator.stripBreaks(component.getPurl()));
        if (this.getSchemaVersion().getVersion() == 1.0 || component.isModified()) {
            this.createElement(componentNode, "modified", component.isModified());
        }
        if (this.getSchemaVersion().getVersion() >= 1.2) {
            this.createSwidNode(componentNode, component.getSwid());
        }
        if (this.getSchemaVersion().getVersion() >= 1.1) {
            this.createPedigreeNode(componentNode, component.getPedigree());
            this.createExternalReferencesNode(componentNode, component.getExternalReferences());
        }
        if (component.getComponents() != null && !component.getComponents().isEmpty()) {
            Element subComponentsNode = this.createElement(componentNode, "components");
            this.createComponentsNode(subComponentsNode, component.getComponents());
        }
        this.processExtensions(componentNode, component);
    }

    private void createHashesNode(Node parent, List<Hash> hashes) {
        if (hashes != null && !hashes.isEmpty()) {
            Element hashesNode = this.createElement(parent, "hashes");
            for (Hash hash : hashes) {
                this.createElement((Node)hashesNode, "hash", (Object)hash.getValue(), new Attribute("alg", hash.getAlgorithm()));
            }
        }
    }

    private void createLicenseNode(Node parent, LicenseChoice licenseChoice) {
        if (licenseChoice != null) {
            Element licensesNode = this.doc.createElement("licenses");
            if (licenseChoice.getLicenses() != null) {
                parent.appendChild(licensesNode);
                for (License license : licenseChoice.getLicenses()) {
                    Element licenseNode = this.doc.createElement("license");
                    if (license.getId() != null) {
                        Element licenseIdNode = this.doc.createElement("id");
                        licenseIdNode.appendChild(this.doc.createTextNode(license.getId()));
                        licenseNode.appendChild(licenseIdNode);
                    } else if (license.getName() != null) {
                        Element licenseNameNode = this.doc.createElement("name");
                        licenseNameNode.appendChild(this.doc.createTextNode(license.getName()));
                        licenseNode.appendChild(licenseNameNode);
                    }
                    if (this.getSchemaVersion().getVersion() >= 1.1) {
                        if (license.getAttachmentText() != null && license.getAttachmentText().getText() != null) {
                            Element licenseTextNode = this.doc.createElement("text");
                            if (license.getAttachmentText().getContentType() != null) {
                                licenseTextNode.setAttribute("content-type", license.getAttachmentText().getContentType());
                            }
                            if (license.getAttachmentText().getEncoding() != null) {
                                licenseTextNode.setAttribute("encoding", license.getAttachmentText().getEncoding());
                                if ("base64".equals(license.getAttachmentText().getEncoding())) {
                                    licenseTextNode.appendChild(this.doc.createTextNode(license.getAttachmentText().getText()));
                                } else {
                                    licenseTextNode.appendChild(this.doc.createCDATASection(license.getAttachmentText().getText()));
                                }
                            } else {
                                licenseTextNode.appendChild(this.doc.createCDATASection(license.getAttachmentText().getText()));
                            }
                            licenseNode.appendChild(licenseTextNode);
                        }
                        if (BomUtils.validateUrlString(license.getUrl())) {
                            Element licenseUrlNode = this.doc.createElement("url");
                            licenseUrlNode.appendChild(this.doc.createTextNode(license.getUrl()));
                            licenseNode.appendChild(licenseUrlNode);
                        }
                        this.processExtensions(licenseNode, license);
                    }
                    licensesNode.appendChild(licenseNode);
                }
            } else if (this.getSchemaVersion().getVersion() >= 1.1 && licenseChoice.getExpression() != null) {
                this.createElement(licensesNode, "expression", AbstractBomXmlGenerator.stripBreaks(licenseChoice.getExpression()));
            }
        }
    }

    private void createSwidNode(Node parent, Swid swid) {
        if (swid != null) {
            Element swidNode = this.createElement(parent, "swid");
            if (swid.getTagId() != null) {
                swidNode.setAttribute("tagId", swid.getTagId());
            }
            if (swid.getName() != null) {
                swidNode.setAttribute("name", swid.getName());
            }
            if (swid.getVersion() != null) {
                swidNode.setAttribute("version", swid.getVersion());
            }
            if (swid.getTagVersion() > 0) {
                swidNode.setAttribute("tagVersion", String.valueOf(swid.getTagVersion()));
            }
            if (swid.isPatch()) {
                swidNode.setAttribute("patch", "true");
            }
            if (swid.getAttachmentText() != null && swid.getAttachmentText().getText() != null) {
                Element attachmentTextNode = this.doc.createElement("text");
                if (swid.getAttachmentText().getContentType() != null) {
                    attachmentTextNode.setAttribute("content-type", swid.getAttachmentText().getContentType());
                }
                if (swid.getAttachmentText().getEncoding() != null) {
                    attachmentTextNode.setAttribute("encoding", swid.getAttachmentText().getEncoding());
                    if ("base64".equals(swid.getAttachmentText().getEncoding())) {
                        attachmentTextNode.appendChild(this.doc.createTextNode(swid.getAttachmentText().getText()));
                    } else {
                        attachmentTextNode.appendChild(this.doc.createCDATASection(swid.getAttachmentText().getText()));
                    }
                } else {
                    attachmentTextNode.appendChild(this.doc.createCDATASection(swid.getAttachmentText().getText()));
                }
                swidNode.appendChild(attachmentTextNode);
            }
        }
    }

    private void createPedigreeNode(Node parent, Pedigree pedigree) {
        if (pedigree != null) {
            Element pedigreeNode = this.createElement(parent, "pedigree");
            if (pedigree.getAncestors() != null && !pedigree.getAncestors().isEmpty()) {
                Element ancestorsNode = this.createElement(pedigreeNode, "ancestors");
                this.createComponentsNode(ancestorsNode, pedigree.getAncestors());
            }
            if (pedigree.getDescendants() != null && !pedigree.getDescendants().isEmpty()) {
                Element descendantsNode = this.createElement(pedigreeNode, "descendants");
                this.createComponentsNode(descendantsNode, pedigree.getDescendants());
            }
            if (pedigree.getVariants() != null && !pedigree.getVariants().isEmpty()) {
                Element variantsNode = this.createElement(pedigreeNode, "variants");
                this.createComponentsNode(variantsNode, pedigree.getVariants());
            }
            if (pedigree.getCommits() != null && !pedigree.getCommits().isEmpty()) {
                Element commitsNode = this.createElement(pedigreeNode, "commits");
                this.createCommitsNode(commitsNode, pedigree.getCommits());
            }
            this.createElement(pedigreeNode, "notes", AbstractBomXmlGenerator.stripBreaks(pedigree.getNotes()));
            this.processExtensions(pedigreeNode, pedigree);
        }
    }

    private void createCommitsNode(Node parent, List<Commit> commits) {
        if (commits != null) {
            for (Commit commit : commits) {
                Element commitNode = this.createElement(parent, "commit");
                this.createElement(commitNode, "uid", AbstractBomXmlGenerator.stripBreaks(commit.getUid()));
                this.createElement(commitNode, "url", AbstractBomXmlGenerator.stripBreaks(commit.getUrl()));
                this.createActorNode(commitNode, "author", commit.getAuthor());
                this.createActorNode(commitNode, "committer", commit.getCommitter());
                this.createElement(commitNode, "message", AbstractBomXmlGenerator.stripBreaks(commit.getMessage()));
                this.processExtensions(commitNode, commit);
            }
        }
    }

    private void createActorNode(Node parent, String nodeName, IdentifiableActionType actor) {
        if (actor != null) {
            Element authorNode = this.createElement(parent, nodeName);
            if (actor.getTimestamp() != null) {
                this.createElement(authorNode, "timestamp", this.dateFormat.format(actor.getTimestamp()));
            }
            this.createElement(authorNode, "name", AbstractBomXmlGenerator.stripBreaks(actor.getName()));
            this.createElement(authorNode, "email", AbstractBomXmlGenerator.stripBreaks(actor.getEmail()));
            this.processExtensions(authorNode, actor);
        }
    }

    void createExternalReferencesNode(Node parent, List<ExternalReference> references) {
        if (references != null && !references.isEmpty()) {
            Element externalReferencesNode = this.createElement(parent, "externalReferences");
            for (ExternalReference reference : references) {
                if (reference.getType() == null || !BomUtils.validateUrlString(reference.getUrl())) continue;
                Element referenceNode = this.createElement((Node)externalReferencesNode, "reference", null, new Attribute("type", reference.getType().getTypeName()));
                this.createElement(referenceNode, "url", AbstractBomXmlGenerator.stripBreaks(reference.getUrl()));
                this.createElement(referenceNode, "comment", AbstractBomXmlGenerator.stripBreaks(reference.getComment()));
            }
        }
    }

    void createDependenciesNode(Node parent, List<Dependency> dependencies) {
        if (dependencies != null && !dependencies.isEmpty()) {
            for (Dependency dependency : dependencies) {
                String nodeName = this.getSchemaVersion().getVersion() >= 1.2 ? "dependency" : "dg:dependency";
                Element dependencyNode = this.createElement(parent, nodeName, null, new Attribute("ref", dependency.getRef()));
                if (dependency.getDependencies() == null || dependency.getDependencies().isEmpty()) continue;
                this.createDependenciesNode(dependencyNode, dependency.getDependencies());
            }
        }
    }

    void createMetadataNode(Node parent, Metadata metadata) {
        if (metadata != null) {
            Element metadataNode = this.createElement(parent, "metadata");
            if (metadata.getTimestamp() != null) {
                this.createElement(metadataNode, "timestamp", this.dateFormat.format(metadata.getTimestamp()));
            }
            this.createToolsNode(metadataNode, metadata.getTools());
            this.createOrganizationalContactsNode(metadataNode, metadata.getAuthors(), "authors", "author");
            this.createComponentNode(metadataNode, metadata.getComponent());
            this.createOrganizationalEntityNode(metadataNode, metadata.getManufacture(), "manufacture");
            this.createOrganizationalEntityNode(metadataNode, metadata.getSupplier(), "supplier");
            this.processExtensions(metadataNode, metadata);
        }
    }

    private void createToolsNode(Node parent, List<Tool> tools) {
        if (tools != null && !tools.isEmpty()) {
            Element toolsNode = this.createElement(parent, "tools");
            for (Tool tool : tools) {
                Element toolNode = this.createElement(toolsNode, "tool");
                this.createElement(toolNode, "vendor", AbstractBomXmlGenerator.stripBreaks(tool.getVendor()));
                this.createElement(toolNode, "name", AbstractBomXmlGenerator.stripBreaks(tool.getName()));
                this.createElement(toolNode, "version", AbstractBomXmlGenerator.stripBreaks(tool.getVersion()));
                this.createHashesNode(toolNode, tool.getHashes());
                this.processExtensions(toolNode, tool);
            }
        }
    }

    private void createOrganizationalContactsNode(Node parent, List<OrganizationalContact> contacts, String parentElementName, String elementName) {
        if (contacts != null && !contacts.isEmpty()) {
            Element contactsNode = this.createElement(parent, parentElementName);
            for (OrganizationalContact contact : contacts) {
                this.createOrganizationalContactNode(contactsNode, contact, elementName);
            }
        }
    }

    private void createOrganizationalContactNode(Node parent, OrganizationalContact contact, String elementName) {
        Element contactNode = this.createElement(parent, elementName);
        this.createElement(contactNode, "name", AbstractBomXmlGenerator.stripBreaks(contact.getName()));
        this.createElement(contactNode, "email", AbstractBomXmlGenerator.stripBreaks(contact.getEmail()));
        this.createElement(contactNode, "phone", AbstractBomXmlGenerator.stripBreaks(contact.getPhone()));
        this.processExtensions(contactNode, contact);
    }

    private void createOrganizationalEntityNode(Node parent, OrganizationalEntity entity, String elementName) {
        if (entity != null) {
            Element entityNode = this.createElement(parent, elementName);
            this.createElement(entityNode, "name", AbstractBomXmlGenerator.stripBreaks(entity.getName()));
            this.createElement(entityNode, "url", AbstractBomXmlGenerator.stripBreaks(entity.getUrl()));
            if (entity.getContacts() != null && entity.getContacts().size() > 0) {
                this.createOrganizationalContactNode(entityNode, entity.getContacts().get(0), "contact");
            }
            this.processExtensions(entityNode, entity);
        }
    }

    protected void processExtensions(Node node, ExtensibleElement extensibleElement) {
        if (extensibleElement != null && extensibleElement.getExtensibleTypes() != null) {
            for (ExtensibleType t : extensibleElement.getExtensibleTypes()) {
                Element e = this.createElementNS(node, t.getNamespace(), t.getName());
                if (t.getAttributes() != null) {
                    for (Attribute attr : t.getAttributes()) {
                        e.setAttribute(attr.getKey(), attr.getValue());
                    }
                }
                if (t.getValue() != null) {
                    e.appendChild(this.doc.createTextNode(t.getValue()));
                    continue;
                }
                if (t.getExtensibleTypes() == null) continue;
                for (ExtensibleType childType : t.getExtensibleTypes()) {
                    Element childNode = this.createElementNS(e, childType.getNamespace(), childType.getName());
                    this.processExtensions(childNode, childType);
                }
            }
        }
    }

    Element createRootElement(String name, Object value, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = this.doc.createElementNS(this.getSchemaVersion().getNamespace(), name);
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                node.appendChild(this.doc.createTextNode(value.toString()));
            }
            this.doc.appendChild(node);
        }
        return node;
    }

    static String stripBreaks(String in) {
        if (in == null) {
            return null;
        }
        return in.trim().replace("\r\n", " ").replace("\n", " ").replace("\t", " ").replace("\r", " ").replaceAll(" +", " ");
    }

    @Override
    public String toXmlString() throws TransformerException {
        if (this.doc == null) {
            return null;
        }
        DOMSource domSource = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Override
    public String toString() {
        try {
            return this.toXmlString();
        }
        catch (TransformerException e) {
            return "";
        }
    }
}

