/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.generators.xml;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.xml.AbstractBomXmlGenerator;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.Bom;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BomXmlGenerator11
extends AbstractBomXmlGenerator
implements BomXmlGenerator {
    private final Bom bom;

    public BomXmlGenerator11(Bom bom) {
        this.bom = bom;
    }

    @Override
    public CycloneDxSchema.Version getSchemaVersion() {
        return CycloneDxSchema.Version.VERSION_11;
    }

    @Override
    public Document generate() throws ParserConfigurationException {
        DocumentBuilder docBuilder = this.buildSecureDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.doc.setXmlStandalone(true);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute("xmlns", "http://cyclonedx.org/schema/bom/1.1"));
        attributes.add(new Attribute("version", String.valueOf(this.bom.getVersion())));
        if (this.bom.getDependencies() != null && this.bom.getDependencies().size() > 0) {
            attributes.add(new Attribute("xmlns:dg", "http://cyclonedx.org/schema/ext/dependency-graph/1.0"));
        }
        Element bomNode = this.createRootElement("bom", null, attributes.toArray(new Attribute[0]));
        if (this.bom.getSerialNumber() != null) {
            bomNode.setAttribute("serialNumber", this.bom.getSerialNumber());
        }
        Element componentsNode = this.createElement(bomNode, "components");
        this.createComponentsNode(componentsNode, this.bom.getComponents());
        this.createExternalReferencesNode(bomNode, this.bom.getExternalReferences());
        if (this.bom.getDependencies() != null && this.bom.getDependencies().size() > 0) {
            Element dependenciesNode = this.createElement(bomNode, "dg:dependencies");
            this.createDependenciesNode(dependenciesNode, this.bom.getDependencies());
        }
        this.processExtensions(bomNode, this.bom);
        return this.doc;
    }
}

