/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.parsers;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.model.Bom;
import org.cyclonedx.parsers.Parser;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;

public class JsonParser
extends CycloneDxSchema
implements Parser {
    @Override
    public Bom parse(File file) throws ParseException {
        try {
            String jsonString = IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8);
            return (Bom)JSON.parseObject((String)jsonString, Bom.class, (Feature[])new Feature[]{Feature.SupportNonPublicField});
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from File", e);
        }
    }

    @Override
    public Bom parse(byte[] bomBytes) throws ParseException {
        try {
            return (Bom)JSON.parseObject((byte[])bomBytes, Bom.class, (Feature[])new Feature[]{Feature.SupportNonPublicField});
        }
        catch (RuntimeException e) {
            throw new ParseException("Unable to parse BOM from byte array", e);
        }
    }

    @Override
    public Bom parse(InputStream inputStream) throws ParseException {
        try {
            return (Bom)JSON.parseObject((InputStream)inputStream, Bom.class, (Feature[])new Feature[]{Feature.SupportNonPublicField});
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from InputStream", e);
        }
    }

    @Override
    public Bom parse(Reader reader) throws ParseException {
        try {
            InputStream in = IOUtils.toInputStream((String)IOUtils.toString((Reader)reader), (Charset)StandardCharsets.UTF_8);
            return (Bom)JSON.parseObject((InputStream)in, Bom.class, (Feature[])new Feature[]{Feature.SupportNonPublicField});
        }
        catch (IOException e) {
            throw new ParseException("Unable to parse BOM from Reader", e);
        }
    }

    @Override
    public List<ParseException> validate(File file) throws IOException {
        return this.validate(file, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), schemaVersion, false);
    }

    public List<ParseException> validate(File file, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(new String(bomBytes), schemaVersion, false);
    }

    public List<ParseException> validate(byte[] bomBytes, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(new String(bomBytes), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(Reader reader) throws IOException {
        return this.validate(reader, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString((Reader)reader), schemaVersion, false);
    }

    public List<ParseException> validate(Reader reader, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(IOUtils.toString((Reader)reader), schemaVersion, strict);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream) throws IOException {
        return this.validate(inputStream, CycloneDxSchema.VERSION_LATEST);
    }

    @Override
    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), schemaVersion, false);
    }

    public List<ParseException> validate(InputStream inputStream, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), schemaVersion, strict);
    }

    public List<ParseException> validate(String bomString, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(new JSONObject(bomString), schemaVersion, strict);
    }

    public List<ParseException> validate(JSONObject bomJson, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        ArrayList<ParseException> exceptions = new ArrayList<ParseException>();
        try {
            this.getJsonSchema(schemaVersion, strict).validate((Object)bomJson);
        }
        catch (ValidationException e) {
            exceptions.add(new ParseException(e.getMessage(), e));
        }
        return exceptions;
    }

    @Override
    public boolean isValid(File file) throws IOException {
        return this.validate(file).isEmpty();
    }

    @Override
    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(file, schemaVersion).isEmpty();
    }

    public boolean isValid(File file, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(file, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes) throws IOException {
        return this.validate(bomBytes).isEmpty();
    }

    @Override
    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(bomBytes, schemaVersion).isEmpty();
    }

    public boolean isValid(byte[] bomBytes, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(bomBytes, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader) throws IOException {
        return this.validate(reader).isEmpty();
    }

    @Override
    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(reader, schemaVersion).isEmpty();
    }

    public boolean isValid(Reader reader, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(reader, schemaVersion, strict).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream) throws IOException {
        return this.validate(inputStream).isEmpty();
    }

    @Override
    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion) throws IOException {
        return this.validate(inputStream, schemaVersion).isEmpty();
    }

    public boolean isValid(InputStream inputStream, CycloneDxSchema.Version schemaVersion, boolean strict) throws IOException {
        return this.validate(inputStream, schemaVersion, strict).isEmpty();
    }
}

