/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.json.JSONArray;
import org.json.JSONObject;

public final class LicenseResolver {
    private static Map<String, List<String>> mappings = new HashMap<String, List<String>>();

    private LicenseResolver() {
    }

    public static LicenseChoice resolve(String licenseString, boolean includeLicenseText) {
        try {
            LicenseChoice licenseChoice = LicenseResolver.resolveSpdxLicenseString(licenseString, includeLicenseText);
            if (licenseChoice == null) {
                licenseChoice = LicenseResolver.resolveViaAlternativeMapping(licenseString, includeLicenseText);
            }
            return licenseChoice;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static LicenseChoice resolve(String licenseString) {
        return LicenseResolver.resolve(licenseString, true);
    }

    private static LicenseChoice resolveSpdxLicenseString(String licenseString, boolean includeLicenseText) throws IOException {
        InputStream is = LicenseResolver.class.getResourceAsStream("/licenses/licenses.json");
        String licenseStringModified = LicenseResolver.urlNormalize(licenseString);
        String jsonTxt = IOUtils.toString((InputStream)is, (String)"UTF-8");
        JSONObject json = new JSONObject(jsonTxt);
        JSONArray licenses = json.getJSONArray("licenses");
        for (int i = 0; i < licenses.length(); ++i) {
            String primaryLicenseUrl;
            JSONObject license = licenses.getJSONObject(i);
            boolean isDeprecatedLicenseId = license.getBoolean("isDeprecatedLicenseId");
            String licenseId = license.getString("licenseId");
            String name = license.getString("name");
            JSONArray seeAlso = license.optJSONArray("seeAlso");
            String string = primaryLicenseUrl = seeAlso != null && seeAlso.length() > 0 ? seeAlso.getString(0) : null;
            if (licenseString.trim().equalsIgnoreCase(licenseId)) {
                return LicenseResolver.createLicenseChoice(licenseId, primaryLicenseUrl, isDeprecatedLicenseId, includeLicenseText);
            }
            if (licenseString.trim().equalsIgnoreCase(name)) {
                return LicenseResolver.createLicenseChoice(licenseId, primaryLicenseUrl, isDeprecatedLicenseId, includeLicenseText);
            }
            if (isDeprecatedLicenseId) continue;
            for (int s = 0; s < seeAlso.length(); ++s) {
                String url = seeAlso.getString(s);
                if (url == null || !licenseStringModified.equalsIgnoreCase(LicenseResolver.urlNormalize(url))) continue;
                return LicenseResolver.createLicenseChoice(licenseId, url, isDeprecatedLicenseId, includeLicenseText);
            }
        }
        return null;
    }

    private static String urlNormalize(String input) {
        return input.trim().replace("https://www.", "").replace("http://www.", "").replace("https://", "").replace("http://", "");
    }

    private static LicenseChoice createLicenseChoice(String licenseId, String primaryLicenseUrl, boolean isDeprecatedLicenseId, boolean includeLicenseText) throws IOException {
        InputStream is;
        LicenseChoice choice = new LicenseChoice();
        License license = new License();
        license.setId(licenseId);
        license.setUrl(primaryLicenseUrl);
        if (!isDeprecatedLicenseId && includeLicenseText && (is = LicenseResolver.class.getResourceAsStream("/licenses/" + licenseId + ".txt")) != null) {
            String text = IOUtils.toString((InputStream)is, (String)"UTF-8");
            AttachmentText attachment = new AttachmentText();
            attachment.setContentType("plain/text");
            attachment.setEncoding("base64");
            attachment.setText(Base64.getEncoder().encodeToString(text.getBytes()));
            license.setLicenseText(attachment);
        }
        choice.addLicense(license);
        return choice;
    }

    private static LicenseChoice resolveViaAlternativeMapping(String licenseString, boolean includeLicenseText) throws IOException {
        if (licenseString == null) {
            return null;
        }
        for (Map.Entry<String, List<String>> mapping : mappings.entrySet()) {
            List<String> names = mapping.getValue();
            if (names == null) continue;
            for (String name : names) {
                if (!licenseString.equalsIgnoreCase(name)) continue;
                if (mapping.getKey().startsWith("(") && mapping.getKey().endsWith(")")) {
                    LicenseChoice lc = new LicenseChoice();
                    lc.setExpression(mapping.getKey());
                    return lc;
                }
                return LicenseResolver.createLicenseChoice(mapping.getKey(), null, false, includeLicenseText);
            }
        }
        return null;
    }

    static {
        InputStream is = LicenseResolver.class.getResourceAsStream("/license-mapping.json");
        try {
            String jsonTxt = IOUtils.toString((InputStream)is, (String)"UTF-8");
            JSONArray json = new JSONArray(jsonTxt);
            for (int i = 0; i < json.length(); ++i) {
                JSONObject mapping = json.getJSONObject(i);
                if (!mappings.containsKey(mapping.getString("exp"))) {
                    mappings.put(mapping.getString("exp"), new ArrayList());
                }
                List<String> names = mappings.get(mapping.getString("exp"));
                for (int n = 0; n < mapping.getJSONArray("names").length(); ++n) {
                    names.add(mapping.getJSONArray("names").getString(n));
                }
                mappings.replace(mapping.getString("exp"), names);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

