/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.github.packageurl.PackageURL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Evidence;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.JsonOnly;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Pedigree;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.ReleaseNotes;
import org.cyclonedx.model.Signature;
import org.cyclonedx.model.Swid;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.LicenseDeserializer;

@JacksonXmlRootElement(localName="component")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"supplier", "author", "publisher", "group", "name", "version", "description", "scope", "hashes", "licenses", "copyright", "cpe", "purl", "swid", "modified", "pedigree", "externalReferences", "properties", "components", "evidence", "releaseNotes", "signature"})
public class Component
extends ExtensibleElement {
    @JacksonXmlProperty(isAttribute=true, localName="bom-ref")
    @JsonProperty(value="bom-ref")
    private String bomRef;
    @JacksonXmlProperty(isAttribute=true, localName="mime-type")
    private String mimeType;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private OrganizationalEntity supplier;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private String author;
    @VersionFilter(versions={"1.1", "1.2", "1.3", "1.4"})
    private String publisher;
    private String group;
    private String name;
    private String version;
    private String description;
    private Scope scope;
    private List<Hash> hashes;
    private LicenseChoice license;
    private String copyright;
    private String cpe;
    private String purl;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private Swid swid;
    private Boolean modified;
    @VersionFilter(versions={"1.1", "1.2", "1.3", "1.4"})
    private Pedigree pedigree;
    @VersionFilter(versions={"1.1", "1.2", "1.3", "1.4"})
    private List<ExternalReference> externalReferences;
    @VersionFilter(versions={"1.3", "1.4"})
    private List<Property> properties;
    private List<Component> components;
    @VersionFilter(versions={"1.3", "1.4"})
    private Evidence evidence;
    @JacksonXmlProperty(isAttribute=true)
    private Type type;
    @VersionFilter(versions={"1.4"})
    private ReleaseNotes releaseNotes;
    @JsonOnly
    @VersionFilter(versions={"1.4"})
    private Signature signature;

    public String getBomRef() {
        return this.bomRef;
    }

    public void setBomRef(String bomRef) {
        this.bomRef = bomRef;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public OrganizationalEntity getSupplier() {
        return this.supplier;
    }

    public void setSupplier(OrganizationalEntity supplier) {
        this.supplier = supplier;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @JacksonXmlElementWrapper(localName="hashes")
    @JacksonXmlProperty(localName="hash")
    public List<Hash> getHashes() {
        return this.hashes;
    }

    public void setHashes(List<Hash> hashes) {
        this.hashes = hashes;
    }

    public void addHash(Hash hash) {
        if (this.hashes == null) {
            this.hashes = new ArrayList<Hash>();
        }
        this.hashes.add(hash);
    }

    @JacksonXmlProperty(localName="licenses")
    @JsonProperty(value="licenses")
    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenseChoice() {
        return this.license;
    }

    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.license = licenseChoice;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Deprecated
    public String getCpe() {
        return this.cpe;
    }

    @Deprecated
    public void setCpe(String cpe) {
        this.cpe = cpe;
    }

    public String getPurl() {
        return this.purl;
    }

    public void setPurl(String purl) {
        this.purl = purl;
    }

    public void setPurl(PackageURL purl) {
        this.purl = purl.canonicalize();
    }

    public Swid getSwid() {
        return this.swid;
    }

    public void setSwid(Swid swid) {
        this.swid = swid;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getModified() {
        return this.modified;
    }

    public Boolean isModified() {
        return this.modified;
    }

    public void setModified(Boolean modified) {
        this.modified = modified;
    }

    public Pedigree getPedigree() {
        return this.pedigree;
    }

    public void setPedigree(Pedigree pedigree) {
        this.pedigree = pedigree;
    }

    @JacksonXmlElementWrapper(localName="externalReferences")
    @JacksonXmlProperty(localName="reference")
    public List<ExternalReference> getExternalReferences() {
        return this.externalReferences;
    }

    public void addExternalReference(ExternalReference externalReference) {
        if (this.externalReferences == null) {
            this.externalReferences = new ArrayList<ExternalReference>();
        }
        this.externalReferences.add(externalReference);
    }

    public void setExternalReferences(List<ExternalReference> externalReferences) {
        this.externalReferences = externalReferences;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    @JacksonXmlElementWrapper(localName="components")
    @JacksonXmlProperty(localName="component")
    public List<Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ReleaseNotes getReleaseNotes() {
        return this.releaseNotes;
    }

    public void setReleaseNotes(ReleaseNotes releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.author, this.publisher, this.group, this.name, this.version, this.description, this.scope, this.hashes, this.license, this.copyright, this.cpe, this.purl, this.swid, this.modified, this.components, this.evidence, this.releaseNotes, this.type});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return this.modified == component.modified && Objects.equals(this.supplier, component.supplier) && Objects.equals(this.author, component.author) && Objects.equals(this.publisher, component.publisher) && Objects.equals(this.group, component.group) && Objects.equals(this.name, component.name) && Objects.equals(this.version, component.version) && Objects.equals(this.description, component.description) && Objects.equals((Object)this.scope, (Object)component.scope) && Objects.equals(this.hashes, component.hashes) && Objects.equals(this.license, component.license) && Objects.equals(this.copyright, component.copyright) && Objects.equals(this.cpe, component.cpe) && Objects.equals(this.purl, component.purl) && Objects.equals(this.swid, component.swid) && Objects.equals(this.components, component.components) && Objects.equals(this.evidence, component.evidence) && Objects.equals(this.mimeType, component.mimeType) && Objects.equals(this.releaseNotes, component.releaseNotes) && Objects.equals((Object)this.type, (Object)component.type);
    }

    public static enum Scope {
        REQUIRED("required"),
        OPTIONAL("optional"),
        EXCLUDED("excluded");

        private final String name;

        public String getScopeName() {
            return this.name;
        }

        private Scope(String name) {
            this.name = name;
        }
    }

    public static enum Type {
        APPLICATION("application"),
        FRAMEWORK("framework"),
        LIBRARY("library"),
        CONTAINER("container"),
        OPERATING_SYSTEM("operating-system"),
        DEVICE("device"),
        FIRMWARE("firmware"),
        FILE("file");

        private final String name;

        public String getTypeName() {
            return this.name;
        }

        private Type(String name) {
            this.name = name;
        }
    }
}

