/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExtensibleElement;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.VersionFilter;
import org.cyclonedx.util.CustomDateSerializer;
import org.cyclonedx.util.LicenseDeserializer;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"timestamp", "tools", "authors", "component", "manufacture", "supplier", "licenses", "properties"})
public class Metadata
extends ExtensibleElement {
    @JsonSerialize(using=CustomDateSerializer.class)
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private Date timestamp = new Date();
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private List<Tool> tools;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private List<OrganizationalContact> authors;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private Component component;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private OrganizationalEntity manufacture;
    @VersionFilter(versions={"1.2", "1.3", "1.4"})
    private OrganizationalEntity supplier;
    @VersionFilter(versions={"1.3", "1.4"})
    private LicenseChoice license;
    @VersionFilter(versions={"1.3", "1.4"})
    private List<Property> properties;

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @JacksonXmlElementWrapper(localName="tools")
    @JacksonXmlProperty(localName="tool")
    public List<Tool> getTools() {
        return this.tools;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public void addTool(Tool tool) {
        if (this.tools == null) {
            this.tools = new ArrayList<Tool>();
        }
        this.tools.add(tool);
    }

    @JacksonXmlElementWrapper(localName="authors")
    @JacksonXmlProperty(localName="author")
    public List<OrganizationalContact> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<OrganizationalContact> authors) {
        this.authors = authors;
    }

    public void addAuthor(OrganizationalContact author) {
        if (this.authors == null) {
            this.authors = new ArrayList<OrganizationalContact>();
        }
        this.authors.add(author);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public OrganizationalEntity getManufacture() {
        return this.manufacture;
    }

    public void setManufacture(OrganizationalEntity manufacture) {
        this.manufacture = manufacture;
    }

    public OrganizationalEntity getSupplier() {
        return this.supplier;
    }

    public void setSupplier(OrganizationalEntity supplier) {
        this.supplier = supplier;
    }

    @JacksonXmlProperty(localName="licenses")
    @JsonProperty(value="licenses")
    @JsonDeserialize(using=LicenseDeserializer.class)
    public LicenseChoice getLicenseChoice() {
        return this.license;
    }

    public void setLicenseChoice(LicenseChoice licenseChoice) {
        this.license = licenseChoice;
    }

    @JacksonXmlElementWrapper(localName="properties")
    @JacksonXmlProperty(localName="property")
    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void addProperty(Property property) {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
        }
        this.properties.add(property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.timestamp, metadata.timestamp) && Objects.equals(this.tools, metadata.tools) && Objects.equals(this.authors, metadata.authors) && Objects.equals(this.component, metadata.component) && Objects.equals(this.manufacture, metadata.manufacture) && Objects.equals(this.supplier, metadata.supplier) && Objects.equals(this.license, metadata.license) && Objects.equals(this.properties, metadata.properties);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.tools, this.authors, this.component, this.manufacture, this.supplier, this.license, this.properties);
    }
}

