/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.cyclonedx.model.AttachmentText;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;

public final class LicenseResolver {
    private LicenseResolver() {
    }

    public static LicenseChoice resolve(String licenseString) {
        return LicenseResolver.resolve(licenseString, true);
    }

    public static LicenseChoice resolve(String licenseString, boolean includeLicenseText) {
        ObjectMapper mapper = new ObjectMapper();
        return LicenseResolver.resolve(licenseString, includeLicenseText, mapper);
    }

    static LicenseChoice resolve(String licenseString, boolean includeLicenseText, ObjectMapper mapper) {
        try {
            LicenseChoice licenseChoice = LicenseResolver.resolveLicenseString(licenseString, includeLicenseText, mapper);
            if (licenseChoice == null) {
                licenseChoice = LicenseResolver.resolveFuzzyMatching(licenseString, includeLicenseText, mapper);
            }
            return licenseChoice;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static LicenseChoice resolveLicenseString(String licenseString, boolean includeLicenseText, ObjectMapper mapper) throws IOException {
        InputStream is = LicenseResolver.class.getResourceAsStream("/licenses/licenses.json");
        LicenseList licenses = (LicenseList)mapper.readValue(is, LicenseList.class);
        if (licenses != null && licenses.licenses != null && !licenses.licenses.isEmpty()) {
            for (LicenseDetail licenseDetail : licenses.licenses) {
                String primaryLicenseUrl;
                String string = primaryLicenseUrl = licenseDetail.seeAlso != null && !licenseDetail.seeAlso.isEmpty() ? licenseDetail.seeAlso.get(0) : null;
                if (licenseString.trim().equalsIgnoreCase(licenseDetail.licenseId)) {
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, primaryLicenseUrl, licenseDetail.isDeprecatedLicenseId, includeLicenseText);
                }
                if (licenseString.trim().equalsIgnoreCase(licenseDetail.name)) {
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, primaryLicenseUrl, licenseDetail.isDeprecatedLicenseId, includeLicenseText);
                }
                if (licenseDetail.isDeprecatedLicenseId || licenseDetail.seeAlso == null) continue;
                for (String url : licenseDetail.seeAlso) {
                    String licenseStringModified;
                    if (url == null || !(licenseStringModified = LicenseResolver.urlNormalize(licenseString)).equalsIgnoreCase(LicenseResolver.urlNormalize(url))) continue;
                    return LicenseResolver.createLicenseChoice(licenseDetail.licenseId, url, licenseDetail.isDeprecatedLicenseId, includeLicenseText);
                }
            }
        }
        return null;
    }

    private static LicenseChoice resolveFuzzyMatching(String licenseString, boolean includeLicenseText, ObjectMapper mapper) throws IOException {
        if (licenseString == null) {
            return null;
        }
        InputStream is = LicenseResolver.class.getResourceAsStream("/license-mapping.json");
        SpdxLicenseMapping[] mappings = (SpdxLicenseMapping[])mapper.readValue(is, SpdxLicenseMapping[].class);
        if (mappings != null) {
            for (SpdxLicenseMapping licenseMapping : mappings) {
                if (licenseMapping.names == null || licenseMapping.names.isEmpty()) continue;
                for (String name : licenseMapping.names) {
                    if (!licenseString.equalsIgnoreCase(name)) continue;
                    if (licenseMapping.exp.startsWith("(") && licenseMapping.exp.endsWith(")")) {
                        LicenseChoice lc = new LicenseChoice();
                        lc.setExpression(licenseMapping.exp);
                        return lc;
                    }
                    return LicenseResolver.createLicenseChoice(licenseMapping.exp, null, false, includeLicenseText);
                }
            }
        }
        return null;
    }

    private static String urlNormalize(String input) {
        return input.trim().replace("https://www.", "").replace("http://www.", "").replace("https://", "").replace("http://", "");
    }

    private static LicenseChoice createLicenseChoice(String licenseId, String primaryLicenseUrl, boolean isDeprecatedLicenseId, boolean includeLicenseText) throws IOException {
        InputStream is;
        LicenseChoice choice = new LicenseChoice();
        License license = new License();
        license.setId(licenseId);
        license.setUrl(primaryLicenseUrl);
        if (!isDeprecatedLicenseId && includeLicenseText && (is = LicenseResolver.class.getResourceAsStream("/licenses/" + licenseId + ".txt")) != null) {
            String text = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            AttachmentText attachment = new AttachmentText();
            attachment.setContentType("plain/text");
            attachment.setEncoding("base64");
            attachment.setText(Base64.getEncoder().encodeToString(text.getBytes()));
            license.setLicenseText(attachment);
        }
        choice.addLicense(license);
        return choice;
    }

    private static class SpdxLicenseMapping {
        public String exp;
        public List<String> names;

        private SpdxLicenseMapping() {
        }
    }

    private static class LicenseList {
        public String licenseListVersion;
        public List<LicenseDetail> licenses;
        public String releaseDate;

        private LicenseList() {
        }
    }

    private static class LicenseDetail {
        public String reference;
        public boolean isDeprecatedLicenseId;
        public String detailsUrl;
        public String referenceNumber;
        public String name;
        public String licenseId;
        public List<String> seeAlso;
        public boolean isOsiApproved;
        public boolean isFsfLibre;

        private LicenseDetail() {
        }
    }
}

