/*
 * Decompiled with CFR 0.152.
 */
package org.databene.jdbacl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.PooledConnection;
import org.databene.commons.ArrayBuilder;
import org.databene.commons.ArrayFormat;
import org.databene.commons.ArrayUtil;
import org.databene.commons.BeanUtil;
import org.databene.commons.ConfigurationError;
import org.databene.commons.ConnectFailedException;
import org.databene.commons.ErrorHandler;
import org.databene.commons.FileUtil;
import org.databene.commons.HeavyweightIterator;
import org.databene.commons.IOUtil;
import org.databene.commons.ObjectNotFoundException;
import org.databene.commons.ReaderLineIterator;
import org.databene.commons.StringUtil;
import org.databene.commons.SystemInfo;
import org.databene.commons.converter.AnyConverter;
import org.databene.commons.converter.ToStringConverter;
import org.databene.commons.debug.Debug;
import org.databene.commons.depend.DependencyModel;
import org.databene.commons.depend.Dependent;
import org.databene.commons.iterator.ConvertingIterator;
import org.databene.jdbacl.DBExecutionResult;
import org.databene.jdbacl.DatabaseDialect;
import org.databene.jdbacl.JDBCConnectData;
import org.databene.jdbacl.ResultSetConverter;
import org.databene.jdbacl.ResultSetIterator;
import org.databene.jdbacl.ResultsWithMetadata;
import org.databene.jdbacl.SQLScriptException;
import org.databene.jdbacl.SQLUtil;
import org.databene.jdbacl.model.DBConstraint;
import org.databene.jdbacl.model.DBPrimaryKeyConstraint;
import org.databene.jdbacl.model.DBTable;
import org.databene.jdbacl.model.DBUniqueConstraint;
import org.databene.jdbacl.model.TableHolder;
import org.databene.jdbacl.proxy.LoggingPreparedStatementHandler;
import org.databene.jdbacl.proxy.LoggingResultSetHandler;
import org.databene.jdbacl.proxy.LoggingStatementHandler;
import org.databene.jdbacl.proxy.PooledConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBUtil.class);
    private static final Logger JDBC_LOGGER = LoggerFactory.getLogger((String)"org.databene.JDBC");
    private static final Logger SQL_LOGGER = LoggerFactory.getLogger((String)"org.databene.SQL");

    private DBUtil() {
    }

    public static String[] getEnvironmentNames() {
        File databeneFolder = new File(SystemInfo.getUserHome(), "databene");
        String[] fileNames = databeneFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".env.properties");
            }
        });
        String[] result = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            result[i] = fileName.substring(0, fileName.length() - ".env.properties".length());
        }
        return result;
    }

    public static boolean existsEnvironment(String environment) {
        try {
            DBUtil.getConnectData(environment);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, String> getEnvironmentData(String environment) throws IOException {
        return IOUtil.readProperties((String)DBUtil.environmentFileName(environment));
    }

    public static JDBCConnectData getConnectData(String environment) {
        try {
            String path = DBUtil.environmentFileName(environment);
            return JDBCConnectData.parseSingleDbProperties(path);
        }
        catch (IOException e) {
            throw new ConfigurationError("Error reading environment data for '" + environment + "'");
        }
    }

    public static String environmentFileName(String environment) throws IOException {
        String path;
        String filename = environment + ".env.properties";
        File file = FileUtil.getFileIgnoreCase((File)new File(filename), (boolean)false);
        if (!file.exists()) {
            File defaultUserHomeFile = new File(SystemInfo.getUserHome() + SystemInfo.getFileSeparator() + "databene", filename);
            file = FileUtil.getFileIgnoreCase((File)defaultUserHomeFile, (boolean)false);
        }
        if (file.exists()) {
            path = file.getCanonicalPath();
        } else if (IOUtil.isURIAvailable((String)filename)) {
            path = filename;
        } else {
            throw new ConfigurationError("No environment definition '" + filename + "' found");
        }
        return path;
    }

    public static Connection connect(String environment, boolean readOnly) throws ConnectFailedException {
        JDBCConnectData connectData = DBUtil.getConnectData(environment);
        return DBUtil.connect(connectData, readOnly);
    }

    public static Connection connect(JDBCConnectData data, boolean readOnly) throws ConnectFailedException {
        if (StringUtil.isEmpty((CharSequence)data.url)) {
            throw new ConfigurationError("No JDBC URL specified");
        }
        if (StringUtil.isEmpty((CharSequence)data.driver)) {
            throw new ConfigurationError("No JDBC driver class name specified");
        }
        if (!readOnly && data.readOnly) {
            throw new ConfigurationError("Environment is configured to be read only but was connected for read/write access");
        }
        return DBUtil.connect(data.url, data.driver, data.user, data.password, readOnly);
    }

    public static Connection connect(String url, String driverClassName, String user, String password, boolean readOnly) throws ConnectFailedException {
        try {
            if (driverClassName == null) {
                throw new ConfigurationError("No JDBC driver class name provided");
            }
            Class driverClass = BeanUtil.forName((String)driverClassName);
            Driver driver = (Driver)driverClass.newInstance();
            Properties info = new Properties();
            if (user != null) {
                info.put("user", user);
            }
            if (password != null) {
                info.put("password", password);
            }
            JDBC_LOGGER.debug("opening connection to " + url);
            Connection connection = driver.connect(url, info);
            if (connection == null) {
                throw new ConnectFailedException("Connecting the database failed silently - probably due to wrong driver (" + driverClassName + ") or wrong URL format (" + url + ")");
            }
            connection = DBUtil.wrapWithPooledConnection(connection, readOnly);
            return connection;
        }
        catch (Exception e) {
            throw new ConnectFailedException("Connecting " + url + " failed: ", (Throwable)e);
        }
    }

    public static boolean available(String url, String driverClass, String user, String password) {
        try {
            Connection connection = DBUtil.connect(url, driverClass, user, password, false);
            DBUtil.close(connection);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LOGGER.error("Error closing connection", (Throwable)e);
        }
    }

    public static Connection wrapWithPooledConnection(Connection connection, boolean readOnly) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (Connection)Proxy.newProxyInstance(classLoader, new Class[]{Connection.class, PooledConnection.class}, (InvocationHandler)new PooledConnectionHandler(connection, readOnly));
    }

    public static int getOpenConnectionCount() {
        return PooledConnectionHandler.getOpenConnectionCount();
    }

    public static void resetMonitors() {
        LoggingPreparedStatementHandler.resetMonitors();
        LoggingResultSetHandler.resetMonitors();
        LoggingStatementHandler.resetMonitors();
        PooledConnectionHandler.resetMonitors();
    }

    public static Statement createLoggingStatementHandler(Statement statement, boolean readOnly) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        statement = (Statement)Proxy.newProxyInstance(classLoader, new Class[]{Statement.class}, (InvocationHandler)new LoggingStatementHandler(statement, readOnly));
        return statement;
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, boolean readOnly) throws SQLException {
        return DBUtil.prepareStatement(connection, sql, readOnly, 1003, 1007, 1);
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, boolean readOnly, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JDBC_LOGGER.debug("preparing statement: " + sql);
        DBUtil.checkReadOnly(sql, readOnly);
        if (connection instanceof PooledConnection) {
            connection = ((PooledConnection)((Object)connection)).getConnection();
        }
        PreparedStatement statement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (SQL_LOGGER.isDebugEnabled() || JDBC_LOGGER.isDebugEnabled()) {
            statement = (PreparedStatement)Proxy.newProxyInstance(classLoader, new Class[]{PreparedStatement.class}, (InvocationHandler)new LoggingPreparedStatementHandler(statement, sql));
        }
        return statement;
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new ConfigurationError("Closing statement failed", (Throwable)e);
            }
        }
    }

    public static int getOpenStatementCount() {
        return LoggingStatementHandler.getOpenStatementCount();
    }

    public static int getOpenPreparedStatementCount() {
        return LoggingPreparedStatementHandler.getOpenStatementCount();
    }

    public static ResultSet createLoggingResultSet(ResultSet realResultSet, Statement statement) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return (ResultSet)Proxy.newProxyInstance(classLoader, new Class[]{ResultSet.class}, (InvocationHandler)new LoggingResultSetHandler(realResultSet, statement));
    }

    public static Statement getStatement(ResultSet resultSet) {
        try {
            return resultSet.getStatement();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error getting statement from result set", e);
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                throw new ConfigurationError("Closing statement failed", (Throwable)e);
            }
        }
    }

    public static void closeResultSetAndStatement(ResultSet resultSet) {
        if (resultSet != null) {
            DBUtil.closeResultSetAndStatement(resultSet, DBUtil.getStatement(resultSet));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResultSetAndStatement(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            try {
                DBUtil.close(resultSet);
            }
            finally {
                DBUtil.close(statement);
            }
        } else {
            DBUtil.close(statement);
        }
    }

    public static int getOpenResultSetCount() {
        return LoggingResultSetHandler.getOpenResultSetCount();
    }

    public static Object parseAndSimplifyResultSet(ResultSet resultSet) throws SQLException {
        List<Object[]> rows = DBUtil.parseResultSet(resultSet);
        if (rows.size() == 1 && rows.get(0).length == 1) {
            return rows.get(0)[0];
        }
        Object[][] array = new Object[rows.size()][];
        return rows.toArray((T[])array);
    }

    public static List<Object[]> parseResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (resultSet.next()) {
            rows.add(DBUtil.parseResultRow(resultSet));
        }
        return rows;
    }

    protected static Object[] parseResultRow(ResultSet resultSet) throws SQLException {
        int columnCount = DBUtil.columnCount(resultSet);
        Object[] cells = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            cells[i] = resultSet.getObject(i + 1);
        }
        return cells;
    }

    public static int columnCount(ResultSet resultSet) throws SQLException {
        return resultSet.getMetaData().getColumnCount();
    }

    public static long countRows(String tableName, Connection connection) {
        return DBUtil.queryLong("SELECT COUNT(*) FROM " + tableName, connection);
    }

    public static String format(ResultSet resultSet) throws SQLException {
        StringBuilder builder = new StringBuilder();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            builder.append(metaData.getColumnName(i)).append(i < columnCount ? ", " : SystemInfo.getLineSeparator());
        }
        Object parsed = DBUtil.parseAndSimplifyResultSet(resultSet);
        if (parsed instanceof Object[][]) {
            for (Object[] row : (Object[][])parsed) {
                builder.append(ArrayFormat.format((String)", ", (Object[])row)).append(SystemInfo.getLineSeparator());
            }
        } else {
            builder.append(ToStringConverter.convert((Object)parsed, (String)"null"));
        }
        return builder.toString();
    }

    public static String queryString(PreparedStatement statement) {
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new RuntimeException("Expected a row.");
            }
            String value = resultSet.getString(1);
            if (resultSet.next()) {
                throw new RuntimeException("Expected exactly one row, found more.");
            }
            String string = value;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Database query failed: ", e);
        }
        finally {
            DBUtil.close(resultSet);
        }
    }

    public static Long queryLong(String query, Connection connection) {
        return (Long)AnyConverter.convert((Object)DBUtil.queryScalar(query, connection), Long.class);
    }

    public static Integer queryInt(String query, Connection connection) {
        return (Integer)AnyConverter.convert((Object)DBUtil.queryScalar(query, connection), Integer.class);
    }

    public static Object queryScalar(String query, Connection connection) {
        Object object;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            if (!resultSet.next()) {
                throw new RuntimeException("Query has an empty result: " + query);
            }
            Object value = resultSet.getObject(1);
            if (resultSet.next()) {
                throw new RuntimeException("Expected exactly one row, but found more for query: " + query);
            }
            object = value;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Database query failed: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetAndStatement(resultSet, statement);
                throw throwable;
            }
        }
        DBUtil.closeResultSetAndStatement(resultSet, statement);
        return object;
    }

    public static DBExecutionResult executeScriptFile(String scriptUri, String encoding, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) throws IOException {
        return DBUtil.executeScriptFile(scriptUri, encoding, ';', connection, ignoreComments, errorHandler);
    }

    public static DBExecutionResult executeScriptFile(String scriptUri, String encoding, char separator, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) throws IOException {
        BufferedReader reader = IOUtil.getReaderForURI((String)scriptUri, (String)encoding);
        return DBUtil.runScript(reader, separator, connection, ignoreComments, errorHandler);
    }

    public static DBExecutionResult executeScript(String scriptText, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) {
        return DBUtil.executeScript(scriptText, ';', connection, ignoreComments, errorHandler);
    }

    public static DBExecutionResult executeScript(String scriptText, char separator, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) {
        StringReader reader = new StringReader(scriptText);
        return DBUtil.runScript(reader, separator, connection, ignoreComments, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DBExecutionResult runScript(Reader reader, char separator, Connection connection, boolean ignoreComments, ErrorHandler errorHandler) {
        ReaderLineIterator iterator = new ReaderLineIterator(reader);
        Object exception = null;
        Object result = null;
        Boolean changedStructure = false;
        try {
            StringBuilder cmd = new StringBuilder();
            while (iterator.hasNext()) {
                block14: {
                    String sql;
                    boolean lineEndsWithSeparator;
                    String line = iterator.next().trim();
                    if (line.startsWith("--")) continue;
                    if (cmd.length() > 0) {
                        cmd.append('\n');
                    }
                    cmd.append(line);
                    boolean bl = lineEndsWithSeparator = line.length() > 0 && StringUtil.lastChar((String)line) == separator;
                    if (!lineEndsWithSeparator && iterator.hasNext()) continue;
                    if (lineEndsWithSeparator) {
                        cmd.delete(cmd.length() - 1, cmd.length());
                    }
                    if (!((sql = cmd.toString().trim()).length() <= 0 || ignoreComments && StringUtil.startsWithIgnoreCase((String)sql, (String)"COMMENT"))) {
                        try {
                            if (SQLUtil.isQuery(sql)) {
                                result = DBUtil.queryAndSimplify(sql, connection);
                            } else {
                                result = DBUtil.executeUpdate(sql, connection);
                                if (!Boolean.TRUE.equals(changedStructure)) {
                                    Boolean tmp = SQLUtil.mutatesStructure(sql);
                                    if (changedStructure != null || !Boolean.FALSE.equals(tmp)) {
                                        changedStructure = tmp;
                                    }
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (errorHandler == null) {
                                errorHandler = new ErrorHandler(DBUtil.class);
                            }
                            errorHandler.handleError("Error in executing SQL: " + SystemInfo.getLineSeparator() + cmd, (Throwable)e);
                            if (exception == null) break block14;
                            exception = new SQLScriptException(e, iterator.lineCount());
                        }
                    }
                }
                cmd.delete(0, cmd.length());
            }
            Object returnedValue = exception != null ? exception : result;
            DBExecutionResult dBExecutionResult = new DBExecutionResult(returnedValue, changedStructure);
            return dBExecutionResult;
        }
        finally {
            IOUtil.close((Closeable)iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(String sql, Connection connection) throws SQLException {
        if (sql == null || sql.trim().length() == 0) {
            LOGGER.warn("Empty SQL string in executeUpdate()");
            return 0;
        }
        int result = 0;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            result = statement.executeUpdate(sql);
        }
        finally {
            DBUtil.close(statement);
        }
        return result;
    }

    public static <T> T[] queryScalarRowsAsArray(String query, Class<T> componentType, Connection connection) {
        Object[] objectArray;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            ArrayBuilder builder = new ArrayBuilder(componentType);
            while (resultSet.next()) {
                builder.add(AnyConverter.convert((Object)resultSet.getObject(1), componentType));
            }
            objectArray = builder.toArray();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Database query failed: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetAndStatement(resultSet, statement);
                throw throwable;
            }
        }
        DBUtil.closeResultSetAndStatement(resultSet, statement);
        return objectArray;
    }

    public static <T> T[] queryScalarRow(String query, Class<T> componentType, Connection connection) {
        Object[] objectArray;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            DBUtil.assertNext(resultSet, query);
            int columnCount = DBUtil.columnCount(resultSet);
            Object[] result = ArrayUtil.newInstance(componentType, (int)columnCount);
            for (int i = 0; i < columnCount; ++i) {
                Array.set(result, i, AnyConverter.convert((Object)resultSet.getObject(1), componentType));
            }
            DBUtil.assertNoNext(resultSet, query);
            objectArray = result;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Database query failed: " + query, e);
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetAndStatement(resultSet, statement);
                throw throwable;
            }
        }
        DBUtil.closeResultSetAndStatement(resultSet, statement);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object queryAndSimplify(String query, Connection connection) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = DBUtil.executeQuery(query, connection);
            Object object = DBUtil.parseAndSimplifyResultSet(resultSet);
            return object;
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> query(String query, Connection connection) throws SQLException {
        ResultSet resultSet = DBUtil.executeQuery(query, connection);
        try {
            List<Object[]> list = DBUtil.parseResultSet(resultSet);
            return list;
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] querySingleRow(String query, Connection connection) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = DBUtil.executeQuery(query, connection);
            DBUtil.assertNext(resultSet, query);
            Object[] result = DBUtil.parseResultRow(resultSet);
            DBUtil.assertNoNext(resultSet, query);
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            DBUtil.closeResultSetAndStatement(resultSet);
        }
    }

    public static void assertNoNext(ResultSet resultSet, String query) throws SQLException {
        if (resultSet.next()) {
            throw new IllegalStateException("One-row database query returned multiple rows: " + query);
        }
    }

    public static void assertNext(ResultSet resultSet, String query) throws SQLException {
        if (!resultSet.next()) {
            throw new ObjectNotFoundException("Database query did not return a result: " + query);
        }
    }

    public static HeavyweightIterator<Object[]> iterateQueryResults(String query, Connection connection) throws SQLException {
        ResultSet resultSet = connection.createStatement().executeQuery(query);
        ResultSetConverter<Object[]> converter = new ResultSetConverter<Object[]>(Object[].class);
        return new ConvertingIterator((Iterator)((Object)new ResultSetIterator(resultSet)), converter);
    }

    public static ResultSet executeQuery(String query, Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            return statement.executeQuery(query);
        }
        catch (Exception e) {
            DBUtil.close(statement);
            throw new RuntimeException("Error executing query: " + query, e);
        }
    }

    public static String escape(String text) {
        return text.replace("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultsWithMetadata queryWithMetadata(String query, Connection connection) throws SQLException {
        ResultsWithMetadata resultsWithMetadata;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 1; i <= columnCount; ++i) {
                columnNames[i - 1] = metaData.getColumnLabel(i);
            }
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (resultSet.next()) {
                String[] cells = new String[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    cells[i] = resultSet.getString(i + 1);
                }
                rows.add(cells);
            }
            String[][] array = new String[rows.size()][];
            resultsWithMetadata = new ResultsWithMetadata(columnNames, (String[][])rows.toArray((T[])array));
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSetAndStatement(resultSet, statement);
            throw throwable;
        }
        DBUtil.closeResultSetAndStatement(resultSet, statement);
        return resultsWithMetadata;
    }

    public static void checkReadOnly(String sql, boolean readOnly) {
        if (!readOnly) {
            return;
        }
        Boolean mutation = SQLUtil.mutatesDataOrStructure(sql);
        if (mutation == null || mutation.booleanValue()) {
            throw new IllegalStateException("Tried to mutate a database with read-only settings: " + sql);
        }
    }

    public static void logMetaData(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            JDBC_LOGGER.info("Connected to " + metaData.getDatabaseProductName() + ' ' + metaData.getDatabaseProductVersion());
            JDBC_LOGGER.info("Using driver " + metaData.getDriverName() + ' ' + metaData.getDriverVersion());
            JDBC_LOGGER.info("JDBC version " + metaData.getJDBCMajorVersion() + '.' + metaData.getJDBCMinorVersion());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to fetch metadata from connection " + connection);
        }
    }

    public static List<DBTable> dependencyOrderedTables(TableHolder tableHolder) {
        DependencyModel model = new DependencyModel();
        for (DBTable table : tableHolder.getTables()) {
            model.addNode((Dependent)table);
        }
        return model.dependencyOrderedObjects(true);
    }

    public static boolean equivalent(DBUniqueConstraint uk, DBPrimaryKeyConstraint pk) {
        return Arrays.equals(uk.getColumnNames(), pk.getColumnNames());
    }

    public static void assertAllDbResourcesClosed(boolean critical) {
        boolean success = true;
        String message = null;
        if (Debug.active()) {
            success &= PooledConnectionHandler.assertAllConnectionsClosed(false);
            success &= LoggingPreparedStatementHandler.assertAllStatementsClosed(false);
            success &= LoggingStatementHandler.assertAllStatementsClosed(false);
            if (!(success &= LoggingResultSetHandler.assertAllResultSetsClosed(false))) {
                message = "There are unclosed database resources";
            }
        } else {
            int c = DBUtil.getOpenConnectionCount();
            int r = DBUtil.getOpenResultSetCount();
            int s = DBUtil.getOpenStatementCount();
            int p = DBUtil.getOpenPreparedStatementCount();
            boolean bl = success = c == 0 && r == 0 && s == 0 && p == 0;
            if (!success) {
                StringBuilder builder = new StringBuilder();
                if (c != 0) {
                    builder.append(c).append(" connection(s)");
                }
                if (r != 0) {
                    builder.append(builder.length() > 0 ? ", " : "").append(r).append(" result set(s)");
                }
                if (s != 0) {
                    builder.append(builder.length() > 0 ? ", " : "").append(s).append(" statement(s)");
                }
                if (p != 0) {
                    builder.append(builder.length() > 0 ? ", " : "").append(s).append(" prepared statement(s)");
                }
                message = "There are unclosed database resources: " + builder.toString();
            }
        }
        if (!success) {
            if (critical) {
                throw new AssertionError((Object)message);
            }
            LOGGER.warn(message);
        }
    }

    public static boolean containsMandatoryColumn(DBConstraint fk) {
        for (String columnName : fk.getColumnNames()) {
            if (fk.getTable().getColumn(columnName).isNullable()) continue;
            return true;
        }
        return false;
    }

    public static void insert(String table, Connection connection, DatabaseDialect dialect, Object ... values) throws SQLException {
        DBUtil.executeUpdate(SQLUtil.insert(table, dialect, values), connection);
    }
}

